/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal;

import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildInformationManager;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleFormatter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.ModuleInfoPresenter;

@Singleton
public class ModuleInfoPresenterImpl
implements ModuleInfoPresenter {
    private final ModuleInfoPresenter.ModuleInfoView view;
    private final BuildInformationManager infoManager;

    @Inject
    public ModuleInfoPresenterImpl(ModuleInfoPresenter.ModuleInfoView view, BuildInformationManager infoManager) {
        this.view = view;
        this.infoManager = infoManager;
    }

    public void setModule(MavenProjectDTO module) {
        ModuleFormatter moduleFormatter = new ModuleFormatter(module);
        this.view.setBuildStatus(module.getBuildSummary().getResult());
        this.view.setBuildSummary(this.formatSummary(module, moduleFormatter));
        this.view.setCoordinates("Coordinates: " + module.getCoordinates());
        this.view.setProfileSummary("Active profiles: " + moduleFormatter.profiles(true));
        this.view.setProducedArtifacts(this.infoManager.getProducedArtifacts(module.getId()));
        this.view.setArtifactInfo(this.infoManager.getConsumedArtifacts(module.getId()));
        this.view.showInfo();
    }

    public void clear() {
        this.view.hideInfo();
        this.view.setBuildSummary(null);
        this.view.setProfileSummary(null);
        this.view.setProducedArtifacts(Collections.emptyList());
        this.view.setArtifactInfo(Collections.emptyList());
    }

    private String formatSummary(MavenProjectDTO module, ModuleFormatter moduleFormatter) {
        StringBuilder sb = new StringBuilder();
        sb.append(module.getName()).append(this.formatDuration(moduleFormatter));
        return sb.toString();
    }

    private String formatDuration(ModuleFormatter moduleFormatter) {
        String duration = moduleFormatter.duration();
        if (duration.length() > 0) {
            return " built in " + duration;
        }
        return duration;
    }
}

