/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamInclude;
import hudson.model.AbstractBuild;
import hudson.model.InvisibleAction;
import java.io.File;
import java.util.UUID;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.utils.marshal.xref.XReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="maven-build-record")
@XStreamInclude(value={BuildStateDTO.class, StateReference.class})
public class BuildStateRecord
extends InvisibleAction {
    private final UUID id = UUID.randomUUID();
    private final AbstractBuild<?, ?> build;
    private final StateReference state;

    public BuildStateRecord(AbstractBuild<?, ?> build) {
        this.build = (AbstractBuild)Preconditions.checkNotNull(build);
        this.state = new StateReference(new BuildStateDTO());
    }

    public UUID getId() {
        return this.id;
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public BuildStateDTO getState() {
        return (BuildStateDTO)this.state.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XStreamAlias(value="maven-build-record-state-ref")
    public class StateReference
    extends XReference<BuildStateDTO> {
        public StateReference(BuildStateDTO state) {
            super((Object)state);
        }

        public String getPath() {
            return new File(BuildStateRecord.this.getBuild().getRootDir(), String.format("maven-build-%s.xml", BuildStateRecord.this.getId())).getAbsolutePath();
        }
    }
}

