/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.security.ACL;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.hudsonci.maven.model.config.BuildConfigurationDTO;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.plugin.builder.BuildStateRecord;
import org.hudsonci.maven.plugin.builder.MavenBuildAction;
import org.hudsonci.maven.plugin.builder.MavenBuilderDescriptor;
import org.hudsonci.maven.plugin.builder.internal.PerformBuild;
import org.hudsonci.maven.plugin.documents.DocumentNotFoundException;
import org.hudsonci.maven.plugin.install.MavenInstallation;
import org.hudsonci.service.NodeService;
import org.hudsonci.service.SecurityService;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="maven-builder")
public class MavenBuilder
extends Builder {
    private static final Logger log = LoggerFactory.getLogger(MavenBuilder.class);
    private final BuildConfigurationDTO config;
    @XStreamOmitField
    private SecurityService security;
    @XStreamOmitField
    private NodeService nodes;

    public MavenBuilder(BuildConfigurationDTO config) {
        this.config = (BuildConfigurationDTO)Preconditions.checkNotNull((Object)config);
    }

    @Inject
    public void setSecurity(SecurityService security) {
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
    }

    private SecurityService getSecurity() {
        Preconditions.checkState((this.security != null ? 1 : 0) != 0);
        return this.security;
    }

    @Inject
    public void setNodes(NodeService nodes) {
        this.nodes = (NodeService)Preconditions.checkNotNull((Object)nodes);
    }

    public NodeService getNodes() {
        Preconditions.checkState((this.nodes != null ? 1 : 0) != 0);
        return this.nodes;
    }

    public MavenBuilderDescriptor getDescriptor() {
        return (MavenBuilderDescriptor)super.getDescriptor();
    }

    @JellyAccessible
    public BuildConfigurationDTO getConfig() {
        return this.config;
    }

    public MavenInstallation getMavenInstallation() {
        String installationId = this.getConfig().getInstallationId();
        if (installationId != null && !"NONE".equals(installationId)) {
            for (MavenInstallation installation : this.getDescriptor().getInstallations()) {
                if (!installationId.equals(installation.getName())) continue;
                return installation;
            }
        }
        return null;
    }

    public DocumentDTO getDocument(final String id) {
        if (id == null || "NONE".equals(id)) {
            return null;
        }
        log.debug("Getting document for ID: {}", (Object)id);
        DocumentDTO document = null;
        try {
            document = (DocumentDTO)this.getSecurity().callAs2(ACL.SYSTEM, (Callable)new Callable<DocumentDTO>(){

                @Override
                public DocumentDTO call() {
                    return MavenBuilder.this.getDescriptor().getDocuments().getDocument(id, false);
                }
            });
            log.debug("Document: {}", (Object)document);
        }
        catch (DocumentNotFoundException e) {
            log.warn("Ignoring missing document for ID: {}", (Object)id);
        }
        return document;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        BuildStateDTO state = this.attachBuildState(build).getState();
        this.attachBuildAction(build);
        state.setBuildConfiguration(this.getConfig());
        boolean result = new PerformBuild(this, state, build, launcher, listener).execute();
        return result;
    }

    private BuildStateRecord attachBuildState(AbstractBuild<?, ?> build) {
        BuildStateRecord record = new BuildStateRecord(build);
        build.addAction((Action)record);
        return record;
    }

    private void attachBuildAction(AbstractBuild<?, ?> build) {
        if (build.getAction(MavenBuildAction.class) == null) {
            build.addAction((Action)new MavenBuildAction(build));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MavenBuilder that = (MavenBuilder)((Object)o);
        return this.config.equals((Object)that.config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }
}

