/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.hudsonci.maven.eventspy.common.Callback;
import org.hudsonci.maven.eventspy.common.DocumentReference;
import org.hudsonci.maven.model.config.DocumentDTO;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.BuildStateDTO;
import org.hudsonci.maven.model.state.ExecutionActivityDTO;
import org.hudsonci.maven.model.state.ExecutionActivityTypeDTO;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.model.state.RuntimeEnvironmentDTO;
import org.hudsonci.maven.plugin.builder.MavenBuilder;
import org.hudsonci.maven.plugin.builder.internal.ArtifactRegistry;
import org.hudsonci.utils.common.TestAccessible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackImpl
implements Callback {
    private static final Logger log = LoggerFactory.getLogger(CallbackImpl.class);
    private final MavenBuilder owner;
    private final AbstractBuild<?, ?> build;
    private final BuildStateDTO buildState;
    private final File mavenContextDirectory;
    private final ArtifactRegistry artifactRegistry;
    private long commitDurationToDate = 0L;

    public CallbackImpl(MavenBuilder owner, BuildStateDTO state, AbstractBuild<?, ?> build) {
        this.owner = (MavenBuilder)((Object)Preconditions.checkNotNull((Object)((Object)owner)));
        this.build = (AbstractBuild)Preconditions.checkNotNull(build);
        this.buildState = (BuildStateDTO)Preconditions.checkNotNull((Object)state);
        this.mavenContextDirectory = new File(build.getWorkspace().child(".maven").getRemote());
        this.artifactRegistry = new ArtifactRegistry();
        this.open();
    }

    @TestAccessible
    public CallbackImpl(BuildStateDTO buildState) {
        this.owner = null;
        this.build = null;
        this.buildState = (BuildStateDTO)Preconditions.checkNotNull((Object)buildState);
        this.mavenContextDirectory = null;
        this.artifactRegistry = new ArtifactRegistry();
        this.open();
    }

    public File getMavenContextDirectory() {
        return this.mavenContextDirectory;
    }

    public boolean isAborted() {
        return false;
    }

    private void open() {
        this.recordActivity(ExecutionActivityTypeDTO.STARTED);
    }

    public void close() {
        this.recordActivity(ExecutionActivityTypeDTO.FINISHED);
        log.info("EventSpy is finished; closing");
    }

    public void setRuntimeEnvironment(RuntimeEnvironmentDTO env) {
        Preconditions.checkNotNull((Object)env);
        log.debug("Runtime environment captured");
        this.buildState.setRuntimeEnvironment(env);
    }

    public void setParticipatingProjects(List<MavenProjectDTO> projects) {
        Preconditions.checkNotNull(projects);
        log.debug("Adding {} participating projects.", (Object)projects.size());
        this.buildState.getParticipatingProjects().clear();
        this.buildState.getParticipatingProjects().addAll(projects);
    }

    public void updateParticipatingProject(MavenProjectDTO project) {
        Preconditions.checkNotNull((Object)project);
        log.debug("Updating participating project: {}.", (Object)project.getId());
        ListIterator<MavenProjectDTO> iterator = this.buildState.getParticipatingProjects().listIterator();
        while (iterator.hasNext()) {
            if (!((MavenProjectDTO)iterator.next()).getCoordinates().equals((Object)project.getCoordinates())) continue;
            iterator.set(project);
            break;
        }
    }

    public void setArtifacts(Collection<ArtifactDTO> artifacts) {
        this.buildState.getArtifacts().clear();
        this.buildState.withArtifacts(artifacts);
    }

    public void addArtifacts(Collection<ArtifactDTO> artifacts) {
        long start = System.currentTimeMillis();
        for (ArtifactDTO artifactDTO : artifacts) {
            this.artifactRegistry.recordArtifact(artifactDTO);
        }
        int count = this.commitArtifacts();
        long duration = System.currentTimeMillis() - start;
        this.commitDurationToDate += duration;
        log.debug("Committed {} artifacts in {}ms of cumulative {}ms", new Object[]{count, duration, this.commitDurationToDate});
    }

    public DocumentReference getSettingsDocument() {
        return this.getDocumentContent(this.owner.getConfig().getSettingsId());
    }

    public DocumentReference getGlobalSettingsDocument() {
        return this.getDocumentContent(this.owner.getConfig().getGlobalSettingsId());
    }

    public DocumentReference getToolChainsDocument() {
        return this.getDocumentContent(this.owner.getConfig().getToolChainsId());
    }

    private DocumentReference getDocumentContent(String id) {
        String content;
        DocumentDTO document = this.owner.getDocument(id);
        if (document != null && (content = document.getContent()) != null && content.trim().length() != 0) {
            return new DocumentReference(id, content);
        }
        return null;
    }

    private int commitArtifacts() {
        Collection<ArtifactDTO> artifactsToDate = this.artifactRegistry.getAll();
        this.setArtifacts(artifactsToDate);
        return artifactsToDate.size();
    }

    private void recordActivity(ExecutionActivityTypeDTO activityType) {
        this.buildState.getExecutionActivities().add(new ExecutionActivityDTO().withType(activityType).withTimestamp(new Date()));
    }
}

