/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal;

import com.google.common.base.Preconditions;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.util.ArgumentListBuilder;
import hudson.util.ClasspathBuilder;
import java.io.OutputStream;
import java.util.Map;
import org.hudsonci.maven.model.ModelUtil;
import org.hudsonci.maven.model.PropertiesDTO;
import org.hudsonci.maven.model.config.BuildConfigurationDTO;
import org.hudsonci.maven.plugin.builder.internal.MavenConstants;
import org.hudsonci.maven.plugin.builder.internal.PathNormalizer;
import org.hudsonci.utils.common.TestAccessible;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProcessBuilder {
    private final Logger log;
    private boolean windows;
    private BuildConfigurationDTO config;
    private FilePath tmpDir;
    private FilePath mavenHome;
    private FilePath executable;
    private ClasspathBuilder extClasspath;
    private FilePath repository;
    private EnvVars env;
    private Map<String, String> buildVariables;
    private Integer port;
    private FilePath workingDir;
    private OutputStream standardOutput;
    private PathNormalizer normalizer;
    public static final String[] SUPERFLUOUS_OPTIONS = new String[]{"-B", "--batch-mode", "-batch-mode", "-V", "--show-version", "-show-version"};
    public static final String[] BANNED_OPTIONS = new String[]{"--help", "-help", "-h", "--version", "-version", "-v", "-ep", "--encrypt-password", "-encrypt-password", "-emp", "--encrypt-master-password", "-encrypt-master-password"};
    public static final String[] BANNED_PROPERTIES = new String[]{"-Dmaven.ext.class.path=", "-Dhudson.eventspy."};

    public MavenProcessBuilder(Logger log) {
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
    }

    @TestAccessible
    MavenProcessBuilder() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public MavenProcessBuilder withWindows(boolean flag) {
        this.windows = flag;
        return this;
    }

    public MavenProcessBuilder withTmpDir(FilePath dir) {
        this.tmpDir = dir;
        return this;
    }

    public MavenProcessBuilder withMavenHome(FilePath dir) {
        this.mavenHome = dir;
        return this;
    }

    public MavenProcessBuilder withMavenExecutable(FilePath file) {
        this.executable = file;
        return this;
    }

    public MavenProcessBuilder withExtClasspath(ClasspathBuilder classpath) {
        this.extClasspath = classpath;
        return this;
    }

    public MavenProcessBuilder withRepository(FilePath dir) {
        this.repository = dir;
        return this;
    }

    public MavenProcessBuilder withBuildVariables(Map<String, String> variables) {
        this.buildVariables = variables;
        return this;
    }

    public MavenProcessBuilder withEnv(EnvVars env) {
        this.env = env;
        return this;
    }

    public MavenProcessBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public MavenProcessBuilder withConfiguration(BuildConfigurationDTO config) {
        this.config = config;
        return this;
    }

    public MavenProcessBuilder withWorkingDirectory(FilePath dir) {
        this.workingDir = dir;
        return this;
    }

    public MavenProcessBuilder withStandardOutput(OutputStream output) {
        this.standardOutput = output;
        return this;
    }

    private <T> T ensureNotNull(T obj) {
        if (obj == null) {
            throw new IllegalStateException();
        }
        return obj;
    }

    protected String resolve(String value) {
        return value;
    }

    private PathNormalizer getNormalizer() {
        if (this.normalizer == null) {
            this.normalizer = new PathNormalizer(this.windows ? PathNormalizer.Platform.WINDOWS : PathNormalizer.Platform.UNIX);
        }
        return this.normalizer;
    }

    private String normalize(String path) {
        return this.getNormalizer().normalize(path);
    }

    private FilePath normalize(FilePath path) {
        return this.getNormalizer().normalize(path);
    }

    private ClasspathBuilder normalize(ClasspathBuilder path) {
        return this.getNormalizer().normalize(path);
    }

    public ArgumentListBuilder buildArguments() throws Exception {
        this.ensureNotNull(this.config);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add((Object)this.normalize(this.ensureNotNull(this.executable)));
        if (!ModelUtil.isEmpty((String)this.config.getGoals())) {
            String goals = this.resolve(this.config.getGoals());
            args.addTokenized(goals);
            this.detectSuperfluousOptions(args);
            if (this.detectBannedOptions(args)) {
                throw new AbortException("Detected banned options");
            }
        }
        args.add("-V");
        args.add("-B");
        if (ModelUtil.isSet((Boolean)this.config.getErrors())) {
            args.add("-e");
        }
        args.addKeyValuePairs("-D", this.ensureNotNull(this.buildVariables));
        if (this.config.getProperties() != null) {
            for (PropertiesDTO.Entry entry : this.config.getProperties().getEntries()) {
                String value = this.resolve(entry.getValue());
                value = value.trim();
                args.add(String.format("-D%s=%s", entry.getName(), value));
            }
        }
        this.detectBannedProperties(args);
        args.add(String.format("-D%s=%s", "maven.ext.class.path", this.normalize(this.ensureNotNull(this.extClasspath)).toString(this.windows ? ";" : ":")));
        args.add(String.format("-D%s=%d", "hudson.eventspy.port", this.ensureNotNull(this.port)));
        if (ModelUtil.isSet((Boolean)this.config.getPrivateRepository())) {
            if (this.config.getProperties() != null && this.config.getProperties().contains((Object)"maven.repo.local")) {
                this.log.warn("Private repository configured as well as custom '{}' property; Custom property will take precedence", (Object)"maven.repo.local");
            } else {
                args.add(String.format("-D%s=%s", "maven.repo.local", this.normalize(this.ensureNotNull(this.repository))));
            }
        }
        if (!ModelUtil.isEmpty((String)this.config.getPomFile())) {
            String file = this.resolve(this.config.getPomFile());
            args.add("-f").add(file);
        }
        if (ModelUtil.isSet((Boolean)this.config.getOffline())) {
            args.add("-o");
        }
        if (!ModelUtil.isSet((Boolean)this.config.getRecursive())) {
            args.add("-N");
        }
        if (this.config.getProfiles() != null) {
            for (String profile : this.config.getProfiles()) {
                profile = this.resolve(profile);
                args.add("-P").add(profile);
            }
        }
        if (this.config.getProjects() != null) {
            for (String project : this.config.getProjects()) {
                project = this.resolve(project);
                args.add("-pl").add(project);
            }
        }
        if (!ModelUtil.isEmpty((String)this.config.getResumeFrom())) {
            String resumeFrom = this.resolve(this.config.getResumeFrom());
            args.add("-rf").add(resumeFrom);
        }
        if (this.config.getVerbosity() != null) {
            switch (this.config.getVerbosity()) {
                case QUIET: {
                    args.add("-q");
                    break;
                }
                case DEBUG: {
                    args.add("-X");
                }
            }
        }
        if (this.config.getChecksumMode() != null) {
            switch (this.config.getChecksumMode()) {
                case LAX: {
                    args.add("-c");
                    break;
                }
                case STRICT: {
                    args.add("-C");
                }
            }
        }
        if (this.config.getFailMode() != null) {
            switch (this.config.getFailMode()) {
                case FAST: {
                    args.add("-ff");
                    break;
                }
                case AT_END: {
                    args.add("-fae");
                    break;
                }
                case NEVER: {
                    args.add("-fn");
                }
            }
        }
        if (this.config.getMakeMode() != null) {
            switch (this.config.getMakeMode()) {
                case DEPENDENCIES: {
                    args.add("-am");
                    break;
                }
                case DEPENDENTS: {
                    args.add("-amd");
                    break;
                }
                case BOTH: {
                    args.add("-am").add("-amd");
                }
            }
        }
        if (this.config.getSnapshotUpdateMode() != null) {
            switch (this.config.getSnapshotUpdateMode()) {
                case FORCE: {
                    args.add("-U");
                    break;
                }
                case SUPPRESS: {
                    args.add("-nsu");
                }
            }
        }
        if (!ModelUtil.isEmpty((String)this.config.getThreading())) {
            String threading = this.resolve(this.config.getThreading());
            args.add("-T").add(threading);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Arguments:");
            for (String arg : args.toCommandArray()) {
                this.log.debug("  '{}'", (Object)arg);
            }
        }
        return args;
    }

    public ArgumentListBuilder buildOpts() throws Exception {
        this.ensureNotNull(this.config);
        ArgumentListBuilder mavenOpts = new ArgumentListBuilder();
        if (!ModelUtil.isEmpty((String)this.config.getMavenOpts())) {
            String opts = this.resolve(this.config.getMavenOpts());
            mavenOpts.addTokenized(opts);
            this.detectSuperfluousOptions(mavenOpts);
            this.detectBannedProperties(mavenOpts);
            if (this.detectBannedOptions(mavenOpts)) {
                throw new AbortException("Detected banned options");
            }
        }
        if (ModelUtil.isSet((Boolean)this.config.getPrivateTmpdir())) {
            String customTmpdir = this.findArgumentWithPrefix(mavenOpts, String.format("-D%s=", "java.io.tmpdir"));
            if (customTmpdir != null) {
                this.log.warn("Using user-configured tmpdir: {}", (Object)customTmpdir);
            } else if (this.tmpDir != null) {
                String sep;
                String path = this.tmpDir.getRemote();
                if (path.contains(" ")) {
                    this.log.warn("Path contains spaces: {}", (Object)path);
                }
                String string = sep = this.windows ? "\\" : "/";
                if (!path.endsWith(sep)) {
                    path = path + sep;
                }
                mavenOpts.add(String.format("-D%s=%s", "java.io.tmpdir", this.normalize(path)));
            } else {
                this.log.warn("Using default tmpdir");
            }
        }
        return mavenOpts;
    }

    private String findArgumentWithPrefix(ArgumentListBuilder args, String prefix) {
        for (String arg : args.toList()) {
            if (!arg.startsWith(prefix)) continue;
            return arg;
        }
        return null;
    }

    public EnvVars buildEnv() throws Exception {
        this.ensureNotNull(this.env);
        if (this.windows) {
            this.env.put("MAVEN_TERMINATE_CMD", "on");
            this.env.put("MAVEN_BATCH_ECHO", "off");
            this.env.put("MAVEN_BATCH_PAUSE", "off");
        }
        this.env.put("M2_HOME", this.normalize(this.ensureNotNull(this.mavenHome)).getRemote());
        this.env.put("MAVEN_OPTS", this.buildOpts().toStringWithQuote());
        this.env.put("MAVEN_SKIP_RC", MavenConstants.TRUE);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Environment:");
            for (Map.Entry entry : this.env.entrySet()) {
                this.log.debug("  {}='{}'", entry.getKey(), entry.getValue());
            }
        }
        return this.env;
    }

    public Launcher.ProcStarter build(Launcher.ProcStarter starter) throws Exception {
        assert (starter != null);
        return starter.cmds(this.buildArguments()).envs((Map)this.buildEnv()).pwd(this.ensureNotNull(this.workingDir)).stdout(this.ensureNotNull(this.standardOutput));
    }

    boolean detectSuperfluousOptions(ArgumentListBuilder args) {
        assert (args != null);
        boolean detected = false;
        for (String arg : args.toCommandArray()) {
            for (String opt : SUPERFLUOUS_OPTIONS) {
                if (!arg.equals(opt)) continue;
                this.log.warn("Detected superfluous option: {}", (Object)arg);
                detected = true;
            }
        }
        return detected;
    }

    boolean detectBannedOptions(ArgumentListBuilder args) {
        assert (args != null);
        boolean detected = false;
        for (String arg : args.toCommandArray()) {
            for (String opt : BANNED_OPTIONS) {
                if (!arg.equals(opt)) continue;
                this.log.error("Detected banned option: {}", (Object)arg);
                detected = true;
            }
        }
        return detected;
    }

    public boolean detectBannedProperties(ArgumentListBuilder args) {
        assert (args != null);
        boolean detected = false;
        for (String arg : args.toCommandArray()) {
            for (String prop : BANNED_PROPERTIES) {
                if (!arg.startsWith(prop)) continue;
                this.log.warn("Detected banned property: {}", (Object)arg);
                detected = true;
            }
        }
        return detected;
    }
}

