/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.builder.internal.invoker;

import hudson.util.CopyOnWriteMap;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hudsonci.maven.plugin.builder.internal.invoker.Invoker;
import org.hudsonci.maven.plugin.builder.internal.invoker.MethodKey;
import org.hudsonci.utils.common.Varargs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.support.DC;

public class RemoteInvokeHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(RemoteInvokeHandler.class);
    private final Invoker invoker;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Map<Method, MethodKey> keyCache = new CopyOnWriteMap.Hash();

    public RemoteInvokeHandler(Invoker invoker) {
        assert (invoker != null);
        this.invoker = invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MethodKey key;
        assert (proxy != null);
        assert (method != null);
        DC.put(RemoteInvokeHandler.class, (Object)this.counter.getAndIncrement());
        boolean trace = log.isTraceEnabled();
        log.trace("Invoking method: {}", (Object)method);
        Class<?>[] ptypes = method.getParameterTypes();
        if (trace) {
            if (ptypes.length != 0) {
                log.trace("Parameters:");
                for (Class<?> type : ptypes) {
                    log.trace("  {}@{}", type, (Object)type.hashCode());
                }
            }
            Class<?> rtype = method.getReturnType();
            log.trace("Returns:");
            if (rtype != Void.TYPE) {
                log.trace("  {}@{}", rtype, (Object)rtype.hashCode());
            } else {
                log.trace("  void");
            }
            if (args != null) {
                log.trace("Arguments:");
                for (Object arg : args) {
                    if (arg != null) {
                        Class<?> atype = arg.getClass();
                        log.trace("  {} ({}@{})", Varargs.$((Object[])new Object[]{arg, atype, atype.hashCode()}));
                        continue;
                    }
                    log.trace("  null");
                }
            }
        }
        if ((key = this.keyCache.get(method)) == null) {
            key = new MethodKey(method);
            this.keyCache.put(method, key);
        }
        log.trace("Method key: {}", (Object)key);
        MarshalledObject[] margs = null;
        if (args != null) {
            margs = new MarshalledObject[args.length];
            for (int i = 0; i < args.length; ++i) {
                margs[i] = new MarshalledObject<Object>(args[i]);
            }
        }
        try {
            MarshalledObject mresult;
            try {
                mresult = this.invoker.invoke(key, margs);
            }
            catch (InvocationTargetException e) {
                log.error("Invoke failed", e.getTargetException());
                throw e;
            }
            Object result = null;
            if (mresult != null) {
                result = mresult.get();
            }
            if (trace) {
                log.trace("Result:");
                if (result != null) {
                    Class<?> vtype = result.getClass();
                    log.trace("    {} ({}@{})", Varargs.$((Object[])new Object[]{result, vtype, vtype.hashCode()}));
                } else {
                    log.trace("    null");
                }
            }
            Object object = result;
            return object;
        }
        finally {
            DC.remove(RemoteInvokeHandler.class);
        }
    }
}

