/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.dependencymonitor.internal;

import com.google.common.base.Preconditions;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.plugin.dependencymonitor.DependencyMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ProjectDeletedHandler
extends ItemListener {
    private static final Logger log = LoggerFactory.getLogger(ProjectDeletedHandler.class);
    private final DependencyMonitor dependencyMonitor;

    @Inject
    public ProjectDeletedHandler(DependencyMonitor dependencyMonitor) {
        this.dependencyMonitor = (DependencyMonitor)Preconditions.checkNotNull((Object)dependencyMonitor);
    }

    public void onDeleted(Item item) {
        if (item instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)item;
            log.debug("Project has been deleted; puring: {}", (Object)project);
            this.dependencyMonitor.purge(project);
        }
    }
}

