/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal;

import com.google.gwt.user.cellview.client.AbstractHasData;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.cellview.client.TextHeader;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.RowCountChangeEvent;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hudsonci.gwt.common.MaximizedCellTable;
import org.hudsonci.maven.model.state.MavenProjectDTO;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.BuildSummaryPresenter;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.internal.ModuleDataProvider;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.widget.ModuleDurationColumn;
import org.hudsonci.maven.plugin.ui.gwt.buildinfo.widget.ModuleStatusIconColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BuildSummaryViewImpl
extends ResizeComposite
implements BuildSummaryPresenter.BuildSummaryView {
    private final AbstractHasData<MavenProjectDTO> moduleSummary;
    private final Label builderSummary = new Label();

    @Inject
    public BuildSummaryViewImpl() {
        this.moduleSummary = this.initModuleSummary(this.createModuleTable());
        VerticalPanel layout = new VerticalPanel();
        layout.add((Widget)this.builderSummary);
        layout.add(this.moduleSummary);
        ScrollPanel container = new ScrollPanel();
        container.add((Widget)layout);
        this.initWidget((Widget)container);
    }

    @Override
    public void setModuleData(ModuleDataProvider mdp) {
        mdp.addDataDisplay((HasData)this.moduleSummary);
    }

    @Override
    public void setBuildSummaryText(String summaryText) {
        this.builderSummary.setText(summaryText);
    }

    private <T> AbstractHasData<T> initModuleSummary(final AbstractHasData<T> moduleView) {
        moduleView.addRowCountChangeHandler(new RowCountChangeEvent.Handler(){

            public void onRowCountChange(RowCountChangeEvent event) {
                moduleView.setPageSize(event.getNewRowCount());
            }
        });
        return moduleView;
    }

    private AbstractHasData<MavenProjectDTO> createModuleTable() {
        MaximizedCellTable table = new MaximizedCellTable();
        TextHeader header = new TextHeader("Modules");
        table.addColumn((Column)new ModuleStatusIconColumn(), (Header)header);
        table.addColumn(this.getModuleNameColumn(), (Header)header);
        table.addColumn((Column)new ModuleDurationColumn(), (Header)header);
        return table;
    }

    private TextColumn<MavenProjectDTO> getModuleNameColumn() {
        return new TextColumn<MavenProjectDTO>(){

            public String getValue(MavenProjectDTO module) {
                return module.getName();
            }
        };
    }
}

