/*
 * Decompiled with CFR 0.152.
 */
package com.flipthebird.gwthashcodeequals;

class FloatUtil {
    private static final double LN2 = Math.log(2.0);

    static int floatToIntBits(float value) {
        int significand;
        int signBit;
        if (Float.isNaN(value)) {
            return 2143289344;
        }
        if (value == 0.0f) {
            return 1.0f / value == Float.NEGATIVE_INFINITY ? Integer.MIN_VALUE : 0;
        }
        if (value < 0.0f) {
            value = -value;
            signBit = Integer.MIN_VALUE;
        } else {
            signBit = 0;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return signBit | 0x7F800000;
        }
        int exponent = (int)(Math.log(value) / LN2);
        if (exponent < -126) {
            exponent = -126;
        }
        if (((significand = (int)(0.5 + (double)value * Math.exp((double)(-(exponent - 23)) * LN2))) & 0x1000000) != 0) {
            significand >>= 1;
            ++exponent;
        } else if ((significand & 0x800000) == 0) {
            if (exponent == -126) {
                return signBit | significand;
            }
            significand <<= 1;
            --exponent;
        }
        return signBit | exponent + 127 << 23 | significand & 0x7FFFFF;
    }

    static String toBinaryIeee754String(long decimal) {
        String binary = Long.toBinaryString(decimal);
        StringBuilder result = new StringBuilder(binary);
        for (long i = (long)binary.length(); i < 32L; ++i) {
            result.insert(0, "0");
        }
        result.insert(9, " ");
        result.insert(1, " ");
        return result.toString();
    }

    private FloatUtil() {
    }
}

