/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy.common;

import hudson.remoting.Channel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RemotingClient.class);
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final int port;
    private Channel channel;

    public RemotingClient(int port) {
        this.port = port;
    }

    public Channel getChannel() {
        this.ensureOpened();
        return this.channel;
    }

    public boolean isOpen() {
        return this.channel != null;
    }

    private void ensureOpened() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
    }

    public void open() throws IOException, InterruptedException {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        log.debug("Opening w/port: {}", this.port);
        final Socket socket = new Socket((String)null, this.port);
        BufferedInputStream input = new BufferedInputStream(new FilterInputStream(socket.getInputStream()){

            public void close() throws IOException {
                socket.shutdownInput();
            }
        });
        BufferedOutputStream output = new BufferedOutputStream(new FilterOutputStream(socket.getOutputStream()){

            public void close() throws IOException {
                socket.shutdownOutput();
            }
        });
        this.channel = new Channel(this.getClass().getName(), this.executor, Channel.Mode.BINARY, (InputStream)input, (OutputStream)output);
        log.debug("Opened");
    }

    public void join() throws InterruptedException {
        log.debug("Joining");
        this.getChannel().join();
        log.debug("Joined");
    }

    public void close() throws IOException {
        if (this.channel != null) {
            log.debug("Closing");
            this.channel.close();
            this.channel = null;
            log.debug("Closed");
        }
    }

    public String toString() {
        return "RemotingClient{port=" + this.port + ", channel=" + this.channel + '}';
    }

    public static void main(String[] args) throws Exception {
        assert (args != null);
        assert (args.length == 1);
        int port = Integer.parseInt(args[0]);
        RemotingClient client = new RemotingClient(port);
        client.open();
        client.join();
        client.close();
        System.exit(0);
    }

    private static class FilterOutputStream
    extends java.io.FilterOutputStream {
        public FilterOutputStream(OutputStream out) {
            super(out);
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }
}

