/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.model;

import java.util.List;
import org.hudsonci.maven.model.StackTraceDTO;
import org.hudsonci.maven.model.ThrowableDTO;

public class ThrowableDTOHelper {
    public static ThrowableDTO convert(Throwable source, boolean deep) {
        Throwable cause;
        assert (source != null);
        ThrowableDTO target = new ThrowableDTO().withType(source.getClass().getName()).withMessage(source.getMessage()).withStackTrace(ThrowableDTOHelper.convert(source.getStackTrace()));
        if (deep && (cause = source.getCause()) != null) {
            target.withCause(ThrowableDTOHelper.convert(cause, deep));
        }
        return target;
    }

    public static ThrowableDTO convert(Throwable source) {
        return ThrowableDTOHelper.convert(source, true);
    }

    public static StackTraceDTO convert(StackTraceElement[] source) {
        assert (source != null);
        StackTraceDTO target = new StackTraceDTO();
        List<StackTraceDTO.Element> elements = target.getElements();
        for (StackTraceElement element : source) {
            elements.add(ThrowableDTOHelper.convert(element));
        }
        return target;
    }

    public static StackTraceDTO.Element convert(StackTraceElement source) {
        assert (source != null);
        StackTraceDTO.Element target = new StackTraceDTO.Element().withType(source.getClassName()).withMethod(source.getMethodName()).withFile(source.getFileName()).withLine(source.getLineNumber());
        return target;
    }
}

