/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.model.config;

import java.util.Iterator;
import org.hudsonci.maven.model.config.DocumentAttributeDTO;
import org.hudsonci.maven.model.config.DocumentDTO;

public class DocumentDTOHelper {
    public static String asString(DocumentDTO source) {
        assert (source != null);
        StringBuilder buff = new StringBuilder();
        buff.append("{id=").append(source.getId()).append(",name=").append(source.getName()).append(",type=").append((Object)source.getType());
        if (source.getDescription() != null) {
            buff.append(",description=").append(source.getDescription());
        }
        if (source.getContent() != null) {
            buff.append(",content-size=").append(source.getContent().length());
        }
        if (source.getAttributes() != null) {
            buff.append(",attributes=").append(source.getAttributes());
        }
        buff.append("}");
        return buff.toString();
    }

    private static String keyFor(Object name) {
        String key = name instanceof Enum ? ((Enum)name).name() : String.valueOf(name);
        return key;
    }

    public static void setAttribute(DocumentDTO source, Object name, Object value) {
        assert (source != null);
        assert (name != null);
        String key = DocumentDTOHelper.keyFor(name);
        Iterator<DocumentAttributeDTO> iter = source.getAttributes().iterator();
        while (iter.hasNext()) {
            DocumentAttributeDTO attr = iter.next();
            if (!key.equals(attr.getName())) continue;
            iter.remove();
            break;
        }
        source.withAttributes(new DocumentAttributeDTO().withName(key).withValue(String.valueOf(value)));
    }

    public static Object getAttribute(DocumentDTO source, Object name) {
        assert (source != null);
        assert (name != null);
        String key = DocumentDTOHelper.keyFor(name);
        for (DocumentAttributeDTO attr : source.getAttributes()) {
            if (!key.equals(attr.getName())) continue;
            return attr.getValue();
        }
        return null;
    }
}

