/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.utils.event;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hudsonci.utils.event.EventHandler;
import org.hudsonci.utils.event.EventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventProcessorSupport<ContextType, HandlerType extends EventHandler>
implements EventProcessor<ContextType> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<HandlerType> handlers;
    private final Map<Class, HandlerType> eventTypeHandlerMap = new HashMap<Class, HandlerType>();
    private HandlerType defaultHandler;

    public EventProcessorSupport(List<HandlerType> handlers, HandlerType defaultHandler) {
        this.handlers = Preconditions.checkNotNull(handlers);
        this.defaultHandler = defaultHandler;
    }

    public List<HandlerType> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<HandlerType> handlers) {
        this.handlers = Preconditions.checkNotNull(handlers);
    }

    public HandlerType getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(HandlerType defaultHandler) {
        this.defaultHandler = (EventHandler)Preconditions.checkNotNull(defaultHandler);
    }

    @Override
    public void init(ContextType context) {
        this.log.debug("Initializing w/context: {}", context);
        this.log.debug("Handlers:");
        for (EventHandler handler : this.getHandlers()) {
            this.log.debug("  {}", handler);
            handler.init(context);
        }
    }

    @Override
    public void process(Object event) throws Exception {
        Preconditions.checkNotNull(event);
        this.log.trace("Processing event: {}", event);
        try {
            HandlerType handler = this.getEventHandler(event);
            if (handler != null) {
                handler.handle((Object)event);
            } else {
                this.log.warn("Unhandled event: {} ({})", event, (Object)event.getClass().getName());
            }
        }
        catch (Exception e) {
            this.onFailure(e);
        }
    }

    protected void onFailure(Exception cause) throws Exception {
        this.log.error("Processing failure", cause);
        throw cause;
    }

    protected HandlerType getEventHandler(Object event) {
        Preconditions.checkNotNull(event);
        Class<?> type = event.getClass();
        EventHandler target = (EventHandler)this.eventTypeHandlerMap.get(type);
        if (target == null) {
            for (EventHandler handler : this.getHandlers()) {
                if (!handler.accept(event)) continue;
                target = handler;
                break;
            }
            if (target == null) {
                target = this.getDefaultHandler();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Selected handler: {}, for event: {}", target, (Object)type.getName());
            }
            this.eventTypeHandlerMap.put(type, target);
        }
        return (HandlerType)target;
    }
}

