/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.support;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DC {
    public static final String KEY = DC.getProperty("key", "DC");
    public static final String PREFIX = DC.getProperty("prefix", ",");
    public static final String SEPARATOR = DC.getProperty("separator", ",");
    private static InheritableThreadLocal<State> stateHolder = new InheritableThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State();
        }

        @Override
        protected State childValue(State parentValue) {
            return new State(parentValue);
        }
    };

    private static State state() {
        return (State)stateHolder.get();
    }

    public static State getState() {
        return new State(DC.state());
    }

    public static void setState(State state) {
        DC.checkNotNull(state);
        stateHolder.set(state);
    }

    private static Map<String, String> context() {
        return DC.state().context;
    }

    private static LinkedList<String> stack() {
        return DC.state().stack;
    }

    public static boolean isEmpty() {
        return DC.context().isEmpty() && DC.stack().isEmpty();
    }

    public static void clear() {
        DC.context().clear();
        DC.stack().clear();
    }

    public static void reset() {
        stateHolder.remove();
    }

    public static StringBuilder render() {
        Map<String, String> context;
        StringBuilder buff = new StringBuilder();
        LinkedList<String> stack = DC.stack();
        if (!stack.isEmpty()) {
            buff.append(stack);
        }
        if (!(context = DC.context()).isEmpty()) {
            if (buff.length() != 0) {
                buff.append(SEPARATOR);
            }
            buff.append(context);
        }
        return buff;
    }

    private static void update() {
        StringBuilder buff = DC.render();
        if (buff.length() != 0) {
            buff.insert(0, PREFIX);
            MDC.put(KEY, buff.toString());
        } else {
            MDC.remove(KEY);
            DC.reset();
        }
    }

    public static void put(Object key, Object value) {
        DC.checkNotNull(key);
        DC.context().put(key.toString(), String.valueOf(value));
        DC.update();
    }

    public static void put(Class key, Object value) {
        DC.checkNotNull(key);
        DC.put(key.getSimpleName(), value);
    }

    public static String get(Object key) {
        DC.checkNotNull(key);
        return DC.context().get(key.toString());
    }

    public static String get(Class key) {
        DC.checkNotNull(key);
        return DC.get(key.getSimpleName());
    }

    public static void remove(Object key) {
        DC.checkNotNull(key);
        DC.context().remove(key.toString());
        DC.update();
    }

    public static void remove(Class key) {
        DC.checkNotNull(key);
        DC.remove(key.getSimpleName());
    }

    public static void push(Object value) {
        DC.checkNotNull(value);
        DC.stack().addFirst(value.toString());
        DC.update();
    }

    public static String pop() {
        String value = DC.stack().removeFirst();
        DC.update();
        return value;
    }

    public static String peek() {
        return DC.stack().peek();
    }

    private static String getProperty(String name, String defaultValue) {
        return System.getProperty(DC.class.getName() + "." + name, defaultValue);
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static class State {
        private final Map<String, String> context = new HashMap<String, String>();
        private final LinkedList<String> stack = new LinkedList();

        private State() {
        }

        private State(State source) {
            this();
            DC.checkNotNull(source);
            this.context.putAll(source.context);
            this.stack.addAll(source.stack);
        }

        public String toString() {
            return "State{context=" + this.context + ", stack=" + this.stack + '}';
        }
    }
}

