/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30;

import com.google.common.base.Preconditions;
import org.apache.maven.eventspy.EventSpy;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.LoggerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerManagerImpl
implements LoggerManager {
    private static final Logger log = LoggerFactory.getLogger(LoggerManagerImpl.class);
    private final EventSpy spy;
    private final LoggerManager delegate;
    private int threshold = 0;

    public LoggerManagerImpl(EventSpy spy, LoggerManager delegate) {
        this.spy = Preconditions.checkNotNull(spy);
        this.delegate = Preconditions.checkNotNull(delegate);
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public void setThresholds(int threshold) {
        this.setThreshold(threshold);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getThreshold(String role) {
        return this.getThreshold();
    }

    public int getThreshold(String role, String roleHint) {
        return this.getThreshold();
    }

    public org.codehaus.plexus.logging.Logger getLoggerForComponent(String role) {
        return this.getLoggerForComponent(role, null);
    }

    public org.codehaus.plexus.logging.Logger getLoggerForComponent(String role, String roleHint) {
        Preconditions.checkNotNull(role);
        LoggerImpl logger = new LoggerImpl(this.getThreshold(), this.toLoggerName(role, roleHint), this.delegate.getLoggerForComponent(role, roleHint));
        log.debug("Created logger: {}", (Object)logger);
        return logger;
    }

    public void returnComponentLogger(String role, String hint) {
        if (log.isDebugEnabled()) {
            log.debug("Ignoring logger return; name={}", (Object)this.toLoggerName(role, hint));
        }
    }

    public void returnComponentLogger(String role) {
        this.returnComponentLogger(role, null);
    }

    public int getActiveLoggerCount() {
        return -1;
    }

    private String toLoggerName(String role, String roleHint) {
        if (roleHint == null) {
            return role;
        }
        return String.format("%s#%s", role, roleHint);
    }

    private class LoggerImpl
    extends AbstractLogger {
        private org.codehaus.plexus.logging.Logger delegate;

        public LoggerImpl(int threshold, String name, org.codehaus.plexus.logging.Logger delegate) {
            super(threshold, name);
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        private void emitLog(int level, String message, Throwable cause) {
            if (LoggerManagerImpl.this.threshold <= level) {
                LogEvent event = new LogEvent(this.delegate, level, message, cause);
                log.debug("{}", event);
            }
        }

        public void debug(String message, Throwable cause) {
            this.emitLog(0, message, cause);
        }

        public void info(String message, Throwable cause) {
            this.emitLog(1, message, cause);
        }

        public void warn(String message, Throwable cause) {
            this.emitLog(2, message, cause);
        }

        public void error(String message, Throwable cause) {
            this.emitLog(3, message, cause);
        }

        public void fatalError(String message, Throwable cause) {
            this.emitLog(4, message, cause);
        }

        public org.codehaus.plexus.logging.Logger getChildLogger(String name) {
            return new LoggerImpl(this.getThreshold(), String.format("%s.%s", this.getName(), name), this.delegate.getChildLogger(name));
        }

        public String toString() {
            return "LoggerImpl{name='" + this.getName() + '\'' + ", threshold=" + LoggerManagerImpl.this.threshold + '}';
        }
    }

    public static class LogEvent {
        private final org.codehaus.plexus.logging.Logger logger;
        private final int level;
        private final String message;
        private final Throwable cause;

        public LogEvent(org.codehaus.plexus.logging.Logger logger, int level, String message, Throwable cause) {
            this.logger = Preconditions.checkNotNull(logger);
            Preconditions.checkArgument(level >= 0 && level <= 5);
            this.level = level;
            this.message = Preconditions.checkNotNull(message);
            this.cause = cause;
        }

        public org.codehaus.plexus.logging.Logger getLogger() {
            return this.logger;
        }

        public int getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public void delegate() {
            switch (this.level) {
                case 0: {
                    this.logger.debug(this.message, this.cause);
                    break;
                }
                case 1: {
                    this.logger.info(this.message, this.cause);
                    break;
                }
                case 2: {
                    this.logger.warn(this.message, this.cause);
                    break;
                }
                case 3: {
                    this.logger.error(this.message, this.cause);
                    break;
                }
                case 4: {
                    this.logger.fatalError(this.message, this.cause);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        public String toString() {
            return "LogEvent{" + this.logger.getName() + ": level=" + this.level + ", message='" + this.message + '\'' + ", cause=" + this.cause + '}';
        }
    }
}

