/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.eventspy.EventSpy;
import org.hudsonci.maven.eventspy.common.Callback;
import org.hudsonci.maven.eventspy.common.CallbackManager;
import org.hudsonci.maven.eventspy.common.Constants;
import org.hudsonci.maven.eventspy.common.RemotingClient;
import org.hudsonci.maven.eventspy_30.EventSpyHandler;
import org.hudsonci.maven.eventspy_30.EventSpyProcessor;
import org.hudsonci.maven.eventspy_30.EventSpySupport;
import org.hudsonci.maven.model.PropertiesDTOHelper;
import org.hudsonci.maven.model.state.RuntimeEnvironmentDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class RemotingEventSpy
extends EventSpySupport {
    private final EventSpyProcessor processor;
    private RemotingClient client;
    private Callback callback;

    @Inject
    public RemotingEventSpy(List<EventSpyHandler> handlers) {
        Preconditions.checkNotNull(handlers);
        this.processor = new EventSpyProcessor(handlers, null);
    }

    private int getPort() {
        String tmp = this.getProperty("hudson.eventspy.port");
        if (tmp == null) {
            throw new Error("Missing port number");
        }
        return Integer.parseInt(tmp);
    }

    private void openChannel() throws Exception {
        int port = this.getPort();
        this.client = new RemotingClient(port);
        this.client.open();
    }

    private void closeChannel() throws Exception {
        this.client.join();
        this.client.close();
    }

    @Override
    public void init(EventSpy.Context context) throws Exception {
        Preconditions.checkNotNull(context);
        this.log.debug("Initializing");
        super.init(context);
        this.openChannel();
        this.callback = CallbackManager.get(120L, Constants.CALLBACK_WAIT_TIMEOUT_UNIT);
        this.processor.init(new EventSpyHandler.HandlerContext(this.callback));
        RuntimeEnvironmentDTO env = new RuntimeEnvironmentDTO().withVersionProperties(PropertiesDTOHelper.convert(this.getVersionProperties())).withUserProperties(PropertiesDTOHelper.convert(this.getUserProperties())).withSystemProperties(PropertiesDTOHelper.convert(this.getSystemProperties())).withSystemEnvironment(PropertiesDTOHelper.convert(System.getenv())).withWorkingDirectory(this.getWorkingDirectory().getCanonicalPath());
        this.callback.setRuntimeEnvironment(env);
        this.log.debug("Ready");
    }

    public void onEvent(Object event) throws Exception {
        Preconditions.checkNotNull(event);
        this.ensureOpened();
        this.processor.process(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.log.debug("Closing");
        try {
            this.callback.close();
            this.closeChannel();
        }
        finally {
            super.close();
        }
        this.log.debug("Closed");
    }
}

