/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30.handler;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import org.hudsonci.maven.eventspy_30.EventSpyHandler;
import org.hudsonci.maven.eventspy_30.MavenArtifactConverter;
import org.hudsonci.maven.model.state.ArtifactDTO;
import org.hudsonci.maven.model.state.ArtifactOperationDTO;
import org.hudsonci.utils.common.TestAccessible;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.RemoteRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class RepositoryEventHandler
extends EventSpyHandler<RepositoryEvent> {
    private static final List<RepositoryEvent.EventType> interestingArtifactEvents = Arrays.asList(RepositoryEvent.EventType.ARTIFACT_RESOLVED, RepositoryEvent.EventType.ARTIFACT_DOWNLOADED, RepositoryEvent.EventType.ARTIFACT_INSTALLED, RepositoryEvent.EventType.ARTIFACT_DEPLOYED);

    @Override
    public void handle(RepositoryEvent event) throws Exception {
        this.log.debug("Repository event: {}", event);
        this.logRequestTrace(event);
        if (this.isInterestingArtifactEvent(event)) {
            ArtifactDTO artifact = MavenArtifactConverter.convertAetherArtifact(event.getArtifact());
            ArtifactOperationDTO operation = this.resolveOperationType(event);
            this.getBuildRecorder().recordArtifactAction(artifact, operation, event.getFile());
        }
    }

    private void logRepositoryConfiguration(ArtifactOperationDTO operation, RepositoryEvent event) {
        ArtifactRepository repository;
        if (event.getRepository() != null) {
            this.log.debug("Repo type: {}; info {}", event.getRepository().getClass(), (Object)event.getRepository());
        }
        if (ArtifactOperationDTO.DEPLOYED.equals((Object)operation) && (repository = event.getRepository()) instanceof RemoteRepository) {
            RemoteRepository remoteRepo = (RemoteRepository)repository;
            this.log.debug("Deploy info for remote repository: {}", repository);
            this.log.debug("    Authentication: {}", remoteRepo.getAuthentication());
        }
    }

    @TestAccessible
    ArtifactOperationDTO resolveOperationType(RepositoryEvent event) {
        ArtifactOperationDTO result;
        if (null == event.getFile()) {
            for (Exception e : event.getExceptions()) {
                this.log.debug("Artifact not found", e);
            }
            result = ArtifactOperationDTO.NOT_FOUND;
        } else {
            result = ArtifactOperationDTO.valueOf(event.getType().name().substring(9));
        }
        return result;
    }

    private boolean isInterestingArtifactEvent(RepositoryEvent event) {
        return interestingArtifactEvents.contains(event.getType());
    }

    private void logRequestTrace(RepositoryEvent event) {
        if (!this.log.isTraceEnabled()) {
            return;
        }
        RequestTrace currentNode = event.getTrace();
        if (currentNode == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(currentNode.getData().getClass().getSimpleName());
        while ((currentNode = currentNode.getParent()) != null) {
            sb.append(" <= ");
            sb.append(currentNode.getData().getClass().getSimpleName());
        }
        this.log.trace("Trace stack: {}; value {}", (Object)sb.toString(), event.getTrace().getData());
    }
}

