/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DateConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timestampStrCache = null;
    SimpleDateFormat simpleFormat = null;

    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.simpleFormat = new SimpleDateFormat(datePattern);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            this.simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        }
        List<String> optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            TimeZone tz = TimeZone.getTimeZone(optionList.get(1));
            this.simpleFormat.setTimeZone(tz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert(ILoggingEvent le) {
        long timestamp = le.getTimeStamp();
        DateConverter dateConverter = this;
        synchronized (dateConverter) {
            if (timestamp == this.lastTimestamp) {
                return this.timestampStrCache;
            }
            this.lastTimestamp = timestamp;
            this.timestampStrCache = this.simpleFormat.format(new Date(timestamp));
            return this.timestampStrCache;
        }
    }
}

