/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.model;

import org.hudsonci.maven.model.MavenCoordinatesDTO;

public class MavenCoordinatesDTOHelper {
    public static final String SNAPSHOT = "SNAPSHOT";
    public static final String SEPARATOR = ":";

    public static RenderStyle styleOf(String rendered) {
        if (rendered == null) {
            throw new NullPointerException();
        }
        if (rendered.startsWith("{") && rendered.endsWith("}")) {
            return RenderStyle.MAP;
        }
        String[] elements = rendered.split(SEPARATOR);
        if (elements.length == 2) {
            return RenderStyle.GA;
        }
        if (elements.length == 3) {
            return RenderStyle.GAV;
        }
        if (elements.length == 4) {
            return RenderStyle.GATV;
        }
        if (elements.length == 5) {
            return RenderStyle.GATCV;
        }
        throw new IllegalArgumentException("Unable to determine style of coordinates: " + rendered);
    }

    public static String asString(MavenCoordinatesDTO source, RenderStyle style) {
        assert (source != null);
        StringBuilder buff = new StringBuilder();
        switch (style) {
            case MAP: {
                buff.append("{");
                buff.append("g=").append(source.getGroupId());
                buff.append(",a=").append(source.getArtifactId());
                if (source.getType() != null) {
                    buff.append(",t=").append(source.getType());
                }
                if (source.getClassifier() != null) {
                    buff.append(",c=").append(source.getClassifier());
                }
                if (source.getVersion() != null) {
                    buff.append(",v=").append(source.getVersion());
                }
                buff.append("}");
                break;
            }
            case GA: {
                buff.append(source.getGroupId());
                buff.append(SEPARATOR).append(source.getArtifactId());
                break;
            }
            case GAV: {
                buff.append(source.getGroupId());
                buff.append(SEPARATOR).append(source.getArtifactId());
                buff.append(SEPARATOR).append(source.getVersion());
                break;
            }
            case GATV: {
                buff.append(source.getGroupId());
                buff.append(SEPARATOR).append(source.getArtifactId());
                buff.append(SEPARATOR).append(source.getType());
                buff.append(SEPARATOR).append(source.getVersion());
                break;
            }
            case GATCV: {
                buff.append(source.getGroupId());
                buff.append(SEPARATOR).append(source.getArtifactId());
                buff.append(SEPARATOR).append(source.getType());
                buff.append(SEPARATOR).append(source.getClassifier());
                buff.append(SEPARATOR).append(source.getVersion());
                break;
            }
            case GATCV_OPTIONAL: {
                buff.append(source.getGroupId());
                buff.append(SEPARATOR).append(source.getArtifactId());
                if (source.getType() != null) {
                    buff.append(SEPARATOR).append(source.getType());
                }
                if (source.getClassifier() != null) {
                    buff.append(SEPARATOR).append(source.getClassifier());
                }
                if (source.getVersion() == null) break;
                buff.append(SEPARATOR).append(source.getVersion());
            }
        }
        return buff.toString();
    }

    public static String asString(MavenCoordinatesDTO source) {
        return MavenCoordinatesDTOHelper.asString(source, RenderStyle.MAP);
    }

    private static boolean isEmptyString(String value) {
        return value != null && value.trim().length() == 0;
    }

    public static MavenCoordinatesDTO normalize(MavenCoordinatesDTO source) {
        assert (source != null);
        if (MavenCoordinatesDTOHelper.isEmptyString(source.getType())) {
            source.setType(null);
        }
        if (MavenCoordinatesDTOHelper.isEmptyString(source.getClassifier())) {
            source.setClassifier(null);
        }
        if (MavenCoordinatesDTOHelper.isEmptyString(source.getVersion())) {
            source.setVersion(null);
        }
        return source;
    }

    public static boolean isSnapshot(MavenCoordinatesDTO source) {
        assert (source != null);
        String version = source.getVersion();
        return version != null && version.endsWith(SNAPSHOT);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderStyle {
        MAP,
        GA,
        GAV,
        GATV,
        GATCV,
        GATCV_OPTIONAL;

    }
}

