/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30.handler;

import javax.inject.Named;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsSource;
import org.apache.maven.settings.building.StringSettingsSource;
import org.hudsonci.maven.eventspy.common.DocumentReference;
import org.hudsonci.maven.eventspy_30.EventSpyHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class SettingsBuildingRequestHandler
extends EventSpyHandler<SettingsBuildingRequest> {
    @Override
    public void handle(SettingsBuildingRequest event) throws Exception {
        this.log.debug("Settings request: {}", event);
        DocumentReference document = this.getCallback().getSettingsDocument();
        this.log.debug("Settings document: {}", document);
        if (document != null) {
            if (event.getUserSettingsFile() != MavenCli.DEFAULT_USER_SETTINGS_FILE) {
                this.log.warn("Custom settings file configured via command-line as well as via document; document taking precedence");
            }
            this.log.info("Using settings document ID: {}", (Object)document.getId());
            this.log.trace("Content:\n{}", (Object)document.getContent());
            event.setUserSettingsFile(null);
            event.setUserSettingsSource((SettingsSource)new StringSettingsSource((CharSequence)document.getContent(), document.getLocation()));
        }
        document = this.getCallback().getGlobalSettingsDocument();
        this.log.debug("Global settings document: {}", document);
        if (document != null) {
            if (event.getGlobalSettingsFile() != MavenCli.DEFAULT_GLOBAL_SETTINGS_FILE) {
                this.log.warn("Custom global settings file configured via command-line as well as via document; document taking precedence");
            }
            this.log.info("Using global settings document ID: {}", (Object)document.getId());
            this.log.trace("Content:\n{}", (Object)document.getContent());
            event.setGlobalSettingsFile(null);
            event.setGlobalSettingsSource((SettingsSource)new StringSettingsSource((CharSequence)document.getContent(), document.getLocation()));
        }
    }
}

