/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.eventspy_30.handler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.inject.Named;
import org.apache.maven.cli.BatchModeMavenTransferListener;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.cli.QuietMavenTransferListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.hudsonci.maven.eventspy.common.DocumentReference;
import org.hudsonci.maven.eventspy_30.EventSpyHandler;
import org.hudsonci.maven.eventspy_30.handler.ProfileLogger;
import org.sonatype.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class MavenExecutionRequestHandler
extends EventSpyHandler<MavenExecutionRequest> {
    @Override
    public void handle(MavenExecutionRequest event) throws Exception {
        this.log.debug("Execution request: {}", event);
        TransferListener listener = event.getTransferListener();
        if (!(listener instanceof QuietMavenTransferListener)) {
            event.setTransferListener((TransferListener)new BatchModeMavenTransferListener(System.out));
            this.log.debug("Configured batch mode transfer listener");
        }
        ProfileLogger.logRequestProfiles(event);
        this.configureToolChains(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureToolChains(MavenExecutionRequest event) throws IOException {
        DocumentReference document = this.getCallback().getToolChainsDocument();
        if (document == null) {
            return;
        }
        if (event.getUserToolchainsFile() != MavenCli.DEFAULT_USER_TOOLCHAINS_FILE) {
            this.log.warn("Custom tool-chains file configured via command-line as well as via document; document taking precedence");
        }
        this.log.info("Using tool-chains document ID: {}", (Object)document.getId());
        this.log.trace("Content:\n{}", (Object)document.getContent());
        File file = new File(this.getCallback().getMavenContextDirectory(), "toolchains.xml");
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            this.log.warn("Failed to create directory structure for: {}", file);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        try {
            writer.write(document.getContent());
        }
        finally {
            ((Writer)writer).close();
        }
        this.log.debug("Wrote toolchains.xml: {}", file);
        event.setUserToolchainsFile(file);
    }
}

