/*
 * Decompiled with CFR 0.152.
 */
package com.flipthebird.gwthashcodeequals;

final class DoubleUtil {
    static long doubleToLongBits(double v) {
        if (Double.isNaN(v)) {
            return 9221120237041090560L;
        }
        long sign = v < 0.0 ? Long.MIN_VALUE : 0L;
        long exponent = 0L;
        double absV = Math.abs(v);
        if (Double.isInfinite(v)) {
            exponent = 0x7FF0000000000000L;
        } else if (absV == 0.0) {
            exponent = 0L;
        } else {
            int guess = (int)Math.floor(Math.log(absV) / Math.log(2.0));
            guess = Math.max(-1023, Math.min(guess, 1023));
            double exp = Math.pow(2.0, guess);
            absV /= exp;
            while (absV > 2.0) {
                ++guess;
                absV /= 2.0;
            }
            while (absV < 1.0 && guess > 1024) {
                --guess;
                absV *= 2.0;
            }
            exponent = (long)guess + 1023L << 52;
        }
        if (exponent <= 0L) {
            absV /= 2.0;
        }
        long mantissa = (long)(absV % 1.0 * Math.pow(2.0, 52.0));
        return sign | exponent | mantissa & 0xFFFFFFFFFFFFFL;
    }

    private DoubleUtil() {
    }
}

