/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.maven.model;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.hudsonci.maven.model.NameValue;
import org.hudsonci.maven.model.PropertiesDTO;
import org.hudsonci.maven.model.PropertiesDTOHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isSet(Boolean value) {
        return value != null && value != false;
    }

    public static String renderProperties(PropertiesDTO source) {
        if (source == null || source.getEntries().isEmpty()) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (PropertiesDTO.Entry entry : source.getEntries()) {
            buff.append(entry.getName()).append("=").append(entry.getValue()).append("\n");
        }
        return buff.toString();
    }

    public static PropertiesDTO parseProperties(String source) {
        if (source == null) {
            return null;
        }
        if (source.trim().startsWith("-D")) {
            return ModelUtil.parsePropertyOptions(source);
        }
        Properties props = new Properties();
        try {
            props.load(new StringBufferInputStream(source));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return PropertiesDTOHelper.convert(props);
    }

    public static PropertiesDTO parsePropertyOptions(String source) {
        String[] items;
        if (source == null) {
            return null;
        }
        PropertiesDTO props = new PropertiesDTO();
        for (String item : items = source.trim().split("-D")) {
            if (item.length() == 0) continue;
            NameValue nv = NameValue.parse(item);
            props.getEntries().add(new PropertiesDTO.Entry().withName(nv.name).withValue(nv.value));
        }
        return props;
    }

    public static String renderList(List<String> source) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (String item : source) {
            buff.append(item).append("\n");
        }
        return buff.toString();
    }

    public static List<String> parseList(String source) {
        if (source == null || source.trim().length() == 0) {
            return null;
        }
        String[] items = source.trim().split("[\\s,]");
        ArrayList<String> target = new ArrayList<String>(items.length);
        for (String item : items) {
            if (item.length() == 0) continue;
            target.add(item);
        }
        return target;
    }
}

