/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.snapshotmonitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import org.hudsonci.plugins.snapshotmonitor.SnapshotTrigger;
import org.hudsonci.plugins.snapshotmonitor.internal.WatchedDependenciesLoader;
import org.hudsonci.plugins.snapshotmonitor.model.WatchedDependencies;
import org.hudsonci.plugins.snapshotmonitor.model.WatchedDependency;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="watched-dependencies-property")
public class WatchedDependenciesProperty
extends JobProperty<AbstractProject<?, ?>> {
    private static final Logger log = LoggerFactory.getLogger(WatchedDependenciesProperty.class);
    @XStreamOmitField
    private WatchedDependencies watchedDependencies;

    @DataBoundConstructor
    public WatchedDependenciesProperty() {
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    protected void setOwner(AbstractProject<?, ?> owner) {
        super.setOwner(owner);
        try {
            this.watchedDependencies = this.getDescriptor().loader.load((Job)owner);
        }
        catch (IOException e) {
            log.error("Failed to load watched dependencies for: {}", owner, (Object)e);
        }
    }

    public synchronized Collection<WatchedDependency> get() {
        Collection<WatchedDependency> deps = this.watchedDependencies.getDependencies();
        if (deps == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(deps);
    }

    public synchronized void set(Collection<WatchedDependency> dependencies) {
        Preconditions.checkNotNull(dependencies);
        this.watchedDependencies.setDependencies(new HashSet<WatchedDependency>(dependencies));
        try {
            this.getDescriptor().loader.store(this.owner, this.watchedDependencies);
        }
        catch (IOException e) {
            log.error("Failed to update watched dependencies for: {}", (Object)this.owner, (Object)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Named
    @Singleton
    @Typed(value={Descriptor.class})
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        private final WatchedDependenciesLoader loader;

        @Inject
        public DescriptorImpl(WatchedDependenciesLoader loader) {
            this.loader = (WatchedDependenciesLoader)Preconditions.checkNotNull((Object)loader);
        }

        public String getDisplayName() {
            return "Watched dependencies property";
        }

        public boolean isApplicable(Class<? extends Job> type) {
            return AbstractProject.class.isAssignableFrom(type);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req.hasParameter(SnapshotTrigger.class.getName().replace('.', '-'))) {
                return super.newInstance(req, formData);
            }
            return null;
        }
    }
}

