/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.snapshotmonitor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hudsonci.maven.model.MavenCoordinatesDTO;
import org.hudsonci.maven.model.MavenCoordinatesDTOHelper;
import org.hudsonci.maven.plugin.dependencymonitor.ArtifactsExtractor;
import org.hudsonci.maven.plugin.dependencymonitor.ArtifactsPair;
import org.hudsonci.maven.plugin.dependencymonitor.ProjectArtifactCache;
import org.hudsonci.plugins.snapshotmonitor.SnapshotMonitor;
import org.hudsonci.plugins.snapshotmonitor.SnapshotTrigger;
import org.hudsonci.utils.tasks.MetaProject;
import org.hudsonci.utils.tasks.TaskListenerLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.support.MuxLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class WatchedDependenciesUpdater
extends RunListener<AbstractBuild> {
    private static final Logger log = LoggerFactory.getLogger(WatchedDependenciesUpdater.class);
    private final SnapshotMonitor snapshotMonitor;
    private final ArtifactsExtractor extractor;
    private final ProjectArtifactCache projectArtifactCache;

    @Inject
    public WatchedDependenciesUpdater(SnapshotMonitor snapshotMonitor, ArtifactsExtractor extractor, ProjectArtifactCache projectArtifactCache) {
        super(AbstractBuild.class);
        this.snapshotMonitor = (SnapshotMonitor)Preconditions.checkNotNull((Object)snapshotMonitor);
        this.extractor = (ArtifactsExtractor)Preconditions.checkNotNull((Object)extractor);
        this.projectArtifactCache = (ProjectArtifactCache)Preconditions.checkNotNull((Object)projectArtifactCache);
    }

    public void onCompleted(AbstractBuild build, TaskListener listener) {
        assert (build != null);
        TaskListenerLogger logger = new TaskListenerLogger(listener);
        Logger muxlog = MuxLoggerFactory.create((Logger[])new Logger[]{log, logger});
        Result result = build.getResult();
        if (result.isWorseThan(Result.UNSTABLE)) {
            muxlog.debug("Skipping watched dependency update for build: {} due to result: {}", (Object)build, (Object)result);
            return;
        }
        SnapshotTrigger trigger = this.findSnapshotTrigger(build);
        if (trigger == null) {
            muxlog.debug("Skipping watched dependency update; build not configured with trigger: {}", (Object)build);
            return;
        }
        try {
            ArtifactsPair artifacts = this.extractor.extract(build);
            if (artifacts != null) {
                logger.info("Updating watched dependencies");
                HashSet watched = Sets.newHashSet();
                for (MavenCoordinatesDTO dep : artifacts.consumed) {
                    if (!dep.isSnapshot() || "pom".equals(dep.getType())) continue;
                    if (trigger.isExcludeInternallyProduced() && this.projectArtifactCache.isProduced(dep)) {
                        muxlog.debug("Artifact is produced internally; skipping: {}", (Object)dep);
                        continue;
                    }
                    logger.info("  {}", (Object)dep.toString(MavenCoordinatesDTOHelper.RenderStyle.GAV));
                    watched.add(dep);
                }
                this.snapshotMonitor.update(build, watched);
            }
        }
        catch (IOException e) {
            muxlog.error("Failed to update watched dependencies for build: {}", (Object)build, (Object)e);
        }
    }

    private SnapshotTrigger findSnapshotTrigger(AbstractBuild build) {
        AbstractProject project = build instanceof MatrixRun ? (AbstractProject)((MatrixRun)MatrixRun.class.cast(build)).getParentBuild().getParent() : build.getProject();
        for (Trigger trigger : new MetaProject(project).getTriggers()) {
            if (!(trigger instanceof SnapshotTrigger)) continue;
            return (SnapshotTrigger)trigger;
        }
        return null;
    }
}

