/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.plugin.jersey;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.hudsonci.rest.plugin.ApiProvider;
import org.hudsonci.rest.plugin.RestComponentProvider;
import org.hudsonci.rest.server.internal.jersey.RestServlet;
import org.hudsonci.servlets.ServletContainer;
import org.hudsonci.servlets.ServletContainerAware;
import org.hudsonci.servlets.ServletRegistration;
import org.hudsonci.utils.id.OID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class JerseyProvider
extends ApiProvider {
    private static final Logger log = LoggerFactory.getLogger(JerseyProvider.class);
    private static ServletRegistration.Handle handle;

    public boolean isEnabled() {
        return handle != null && handle.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (handle != null) {
            handle.setEnabled(enabled);
        }
    }

    public String toString() {
        return "JAX-RS (Jersey)";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Named
    @Singleton
    public static class ServletInstaller
    implements ServletContainerAware {
        private final RestServlet servlet;
        private final List<RestComponentProvider> providers;

        @Inject
        public ServletInstaller(@Named(value="jersey") RestServlet servlet, List<RestComponentProvider> providers) {
            this.servlet = (RestServlet)Preconditions.checkNotNull((Object)servlet);
            this.providers = (List)Preconditions.checkNotNull(providers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setServletContainer(ServletContainer container) throws Exception {
            assert (container != null);
            log.debug("Installing Jersey servlet");
            ServletRegistration reg = new ServletRegistration();
            reg.setServlet((Servlet)this.servlet);
            reg.setUriPrefix("rest");
            handle = container.register(reg);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            for (RestComponentProvider provider : this.providers) {
                Thread.currentThread().setContextClassLoader(provider.getClass().getClassLoader());
                try {
                    this.includeComponents(provider);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            }
        }

        private void includeComponents(RestComponentProvider provider) {
            assert (provider != null);
            if (log.isDebugEnabled()) {
                log.debug("Adding application for provider: {}", (Object)provider);
                for (Class<?> type : provider.getClasses()) {
                    log.debug("  {}", (Object)type.getName());
                }
                for (Object obj : provider.getSingletons()) {
                    log.debug("  {}", (Object)OID.render((Object)obj));
                }
            }
            this.addApplication(new ProviderApplication(provider));
        }

        private void addApplication(Application app) {
            Preconditions.checkState((this.servlet != null ? 1 : 0) != 0);
            this.servlet.addApplication(app);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProviderApplication
    extends Application {
        private final RestComponentProvider provider;

        public ProviderApplication(RestComponentProvider provider) {
            this.provider = (RestComponentProvider)Preconditions.checkNotNull((Object)provider);
        }

        public RestComponentProvider getProvider() {
            return this.provider;
        }

        public Set<Class<?>> getClasses() {
            HashSet set = new HashSet();
            set.addAll(Arrays.asList(this.getProvider().getClasses()));
            return set;
        }

        public Set<Object> getSingletons() {
            HashSet<Object> set = new HashSet<Object>();
            set.addAll(Arrays.asList(this.getProvider().getSingletons()));
            return set;
        }
    }
}

