/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.plugin;

import com.google.common.base.Preconditions;
import hudson.Plugin;
import hudson.model.Descriptor;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.hudsonci.rest.api.Version;
import org.hudsonci.rest.plugin.ApiProvider;
import org.kohsuke.stapler.StaplerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class RestPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RestPlugin.class);
    private transient List<ApiProvider> providers;
    private boolean enabled = true;

    @Inject
    public RestPlugin(List<ApiProvider> providers) {
        this.providers = (List)Preconditions.checkNotNull(providers);
        log.debug("API version: {}", (Object)Version.get());
        if (log.isDebugEnabled()) {
            log.debug("Providers:");
            for (ApiProvider provider : providers) {
                log.debug("    {}", (Object)provider);
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enable();
    }

    public void enable() {
        for (ApiProvider provider : this.providers) {
            provider.setEnabled(this.enabled);
            log.info("API provider {} {}", (Object)provider, (Object)(this.enabled ? "enabled" : "disabled"));
        }
    }

    public void start() throws Exception {
        this.load();
    }

    public void postInitialize() throws Exception {
        log.debug("Starting providers");
        for (ApiProvider provider : this.providers) {
            provider.start();
        }
    }

    public void stop() throws Exception {
        log.debug("Stopping providers");
        for (ApiProvider provider : this.providers) {
            provider.stop();
        }
    }

    public void configure(StaplerRequest request, JSONObject data) throws IOException, ServletException, Descriptor.FormException {
        Preconditions.checkNotNull((Object)data);
        boolean prev = this.isEnabled();
        this.setEnabled(data.optBoolean("enabled", true));
        if (prev != this.isEnabled()) {
            log.debug("API {}", (Object)(this.enabled ? "enabled" : "disabled"));
        }
        this.save();
    }
}

