/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.plugin.jersey;

import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import hudson.model.Hudson;
import hudson.tasks.Mailer;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hudsonci.rest.server.internal.jersey.RestServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="jersey")
@Singleton
public class RestServletImpl
extends RestServlet {
    private static final Logger log = LoggerFactory.getLogger(RestServletImpl.class);

    @Inject
    public RestServletImpl(@Named(value="smoothie") IoCComponentProviderFactory componentProviderFactory) {
        super(componentProviderFactory);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        if (pathInfo.equals(servletPath)) {
            response.sendError(400, "Missing resource location");
        } else {
            this.detectRootUrl(request);
            super.service(request, response);
        }
    }

    private void detectRootUrl(HttpServletRequest request) {
        assert (request != null);
        String url = Hudson.getInstance().getRootUrl();
        if (url == null) {
            url = this.getRootUrlFrom(request);
            log.debug("Determined URL: {}", (Object)url);
            Mailer.descriptor().setHudsonUrl(url);
        }
    }

    private String getRootUrlFrom(HttpServletRequest request) {
        assert (request != null);
        StringBuilder buff = new StringBuilder();
        buff.append(request.getScheme()).append("://");
        buff.append(request.getServerName());
        if (request.getServerPort() != 80) {
            buff.append(':').append(request.getServerPort());
        }
        buff.append(request.getContextPath()).append('/');
        return buff.toString();
    }
}

