/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.plugin.cometd;

import com.google.common.base.Preconditions;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cometd.Channel;
import org.hudsonci.rest.common.JsonCodec;
import org.hudsonci.rest.model.build.BuildEventDTO;
import org.hudsonci.rest.model.build.BuildEventTypeDTO;
import org.hudsonci.rest.plugin.cometd.CometdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class BuildEventPublisher
extends RunListener<AbstractBuild> {
    private static final String CHANNEL = "/builds";
    private static final Logger log = LoggerFactory.getLogger(BuildEventPublisher.class);
    private final JsonCodec codec;

    @Inject
    public BuildEventPublisher(JsonCodec codec) {
        super(AbstractBuild.class);
        this.codec = (JsonCodec)Preconditions.checkNotNull((Object)codec);
    }

    public void onStarted(AbstractBuild build, TaskListener listener) {
        this.publishEvent(this.createEvent(build, BuildEventTypeDTO.STARTED));
    }

    public void onFinalized(AbstractBuild build) {
        Preconditions.checkNotNull((Object)build);
        this.publishEvent(this.createEvent(build, BuildEventTypeDTO.STOPPED));
    }

    private BuildEventDTO createEvent(AbstractBuild build, BuildEventTypeDTO type) {
        assert (build != null);
        assert (type != null);
        return new BuildEventDTO().withType(type).withProjectName(build.getParent().getFullName()).withBuildNumber(build.getNumber());
    }

    private void publishEvent(BuildEventDTO event) {
        assert (event != null);
        try {
            Channel channel = CometdProvider.getChannel(CHANNEL, false);
            if (channel != null) {
                String data = this.codec.encode((Object)event);
                log.debug("Publishing event w/data: {}", (Object)data);
                channel.publish(null, (Object)data, null);
            } else {
                log.trace("Channel does not exist; skipping publish event");
            }
        }
        catch (Exception e) {
            log.error("Failed to publish event", (Throwable)e);
        }
    }
}

