/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.rest.plugin.cometd;

import com.google.common.base.Preconditions;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.cometd.Bayeux;
import org.cometd.Channel;
import org.cometd.Extension;
import org.cometd.server.AbstractBayeux;
import org.cometd.server.continuation.ContinuationCometdServlet;
import org.cometd.server.ext.AcknowledgedMessagesExtension;
import org.hudsonci.rest.plugin.ApiProvider;
import org.hudsonci.servlets.ServletContainer;
import org.hudsonci.servlets.ServletContainerAware;
import org.hudsonci.servlets.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class CometdProvider
extends ApiProvider {
    private static final Logger log = LoggerFactory.getLogger(CometdProvider.class);
    private static ServletRegistration.Handle handle;
    private static Bayeux bayeux;

    public static Bayeux getBayeux() {
        Preconditions.checkState((bayeux != null ? 1 : 0) != 0);
        return bayeux;
    }

    public boolean isEnabled() {
        return handle != null && handle.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (handle != null) {
            handle.setEnabled(enabled);
        }
    }

    public String toString() {
        return "Bayeux (CometD)";
    }

    public static Channel getChannel(String channel, boolean create) {
        if (bayeux != null) {
            try {
                return bayeux.getChannel(channel, create);
            }
            catch (IllegalStateException e) {
                log.warn("Failed to get channel", (Throwable)e);
            }
        }
        return null;
    }

    @Named
    @Singleton
    public static class ServletInstaller
    implements ServletContainerAware {
        private final ContinuationCometdServlet servlet = new ContinuationCometdServlet(){

            public void init() throws ServletException {
                super.init();
                AbstractBayeux b = ServletInstaller.this.servlet.getBayeux();
                b.addExtension((Extension)new AcknowledgedMessagesExtension());
                bayeux = (Bayeux)b;
            }
        };

        public void setServletContainer(ServletContainer container) throws Exception {
            assert (container != null);
            log.debug("Installing CometD servlet");
            ServletRegistration reg = new ServletRegistration();
            reg.setServlet((Servlet)this.servlet);
            reg.setUriPrefix("cometd");
            reg.addParameter("timeout", "60000");
            handle = container.register(reg);
        }
    }
}

