/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp.runtime;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import netx.jnlp.AppletDesc;
import netx.jnlp.ApplicationDesc;
import netx.jnlp.JNLPFile;
import netx.jnlp.LaunchException;
import netx.jnlp.Launcher;
import netx.jnlp.ParseException;
import netx.jnlp.PropertyDesc;
import netx.jnlp.ResourcesDesc;
import netx.jnlp.cache.UpdatePolicy;
import netx.jnlp.runtime.JNLPRuntime;
import netx.jnlp.services.ServiceUtil;

public final class Boot
implements PrivilegedAction {
    private static final String version = "0.5";
    private static final String aboutFile = "http://jnlp.sourceforge.net/netx/about/netx0.5.jnlp";
    private static final String aboutMessage = "netx v0.5 - (C)2001-2003 Jon A. Maxwell (jmaxwell@users.sourceforge.net)\n\n" + Boot.R("BLaunchAbout");
    private static final String defaultFile = "jar:" + (class$netx$jnlp$runtime$Boot == null ? (class$netx$jnlp$runtime$Boot = Boot.class$("netx.jnlp.runtime.Boot")) : class$netx$jnlp$runtime$Boot).getProtectionDomain().getCodeSource().getLocation() + "!/default.jnlp";
    private static final String miniLicense = "\n   netx - an open-source JNLP client.\n   Copyright (C) 2001-2003 Jon A. Maxwell (JAM)\n\n   // This library is free software; you can redistribute it and/or\n   modify it under the terms of the GNU Lesser General Public\n   License as published by the Free Software Foundation; either\n   version 2.1 of the License, or (at your option) any later version.\n\n   This library is distributed in the hope that it will be useful,\n   but WITHOUT ANY WARRANTY; without even the implied warranty of\n   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n   Lesser General Public License for more details.\n\n   You should have received a copy of the GNU Lesser General Public\n   License along with this library; if not, write to the Free Software\n   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n";
    private static final String helpMessage = "\n" + Boot.R("BOUsage") + "\n" + "  -basedir dir          " + Boot.R("BOBasedir") + "\n" + "  -jnlp location        " + Boot.R("BOJnlp") + "\n" + "  -arg arg              " + Boot.R("BOArg") + "\n" + "  -param name=value     " + Boot.R("BOParam") + "\n" + "  -property name=value  " + Boot.R("BOProperty") + "\n" + "  -update seconds       " + Boot.R("BOUpdate") + "\n" + "  -license              " + Boot.R("BOLicense") + "\n" + "  -verbose              " + Boot.R("BOVerbose") + "\n" + "  -about                " + Boot.R("BOAbout") + "\n" + "  -nosecurity           " + Boot.R("BONosecurity") + "\n" + "  -noupdate             " + Boot.R("BONoupdate") + "\n" + "  -headless             " + Boot.R("BOHeadless") + "\n" + "  -strict               " + Boot.R("BOStrict") + "\n" + "  -help                 " + Boot.R("BOHelp") + "\n";
    private static final String doubleArgs = "-basedir -jnlp -arg -param -property -update";
    private static String[] args;
    static /* synthetic */ Class class$netx$jnlp$runtime$Boot;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    private static String R(String key, Object param) {
        return JNLPRuntime.getMessage(key, new Object[]{param});
    }

    public static void main(String[] argsIn) {
        args = argsIn;
        if (null != Boot.getOption("-license")) {
            System.out.println(miniLicense);
            System.exit(0);
        }
        if (null != Boot.getOption("-help")) {
            System.out.println(helpMessage);
            System.exit(0);
        }
        if (null != Boot.getOption("-about")) {
            System.out.println(aboutMessage);
        }
        if (null != Boot.getOption("-verbose")) {
            JNLPRuntime.setDebug(true);
        }
        if (null != Boot.getOption("-update")) {
            int value = Integer.parseInt(Boot.getOption("-update"));
            JNLPRuntime.setDefaultUpdatePolicy(new UpdatePolicy((long)value * 1000L));
        }
        if (null != Boot.getOption("-headless")) {
            JNLPRuntime.setHeadless(true);
        }
        if (null != Boot.getOption("-noupdate")) {
            JNLPRuntime.setDefaultUpdatePolicy(UpdatePolicy.NEVER);
        }
        AccessController.doPrivileged(new Boot());
        args = null;
    }

    public Object run() {
        JNLPRuntime.setBaseDir(Boot.getBaseDir());
        JNLPRuntime.setSecurityEnabled(null == Boot.getOption("-nosecurity"));
        JNLPRuntime.initialize();
        try {
            new Launcher().launch(Boot.getFile());
        }
        catch (LaunchException ex) {
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            Boot.fatalError(ex.getMessage());
        }
        return null;
    }

    private static void fatalError(String message) {
        System.err.println("netx: " + message);
        System.exit(1);
    }

    private static JNLPFile getFile() throws ParseException, MalformedURLException, IOException {
        String location = Boot.getOption("-jnlp");
        if (null != Boot.getOption("-about")) {
            location = aboutFile;
        }
        if (location == null) {
            location = defaultFile;
        }
        if (location == null) {
            Boot.fatalError(Boot.R("BNeedsFile") + helpMessage);
        }
        if (JNLPRuntime.isDebug()) {
            System.out.println(Boot.R("BFileLoc") + ": " + location);
        }
        URL url = null;
        url = new File(location).exists() ? new File(location).toURL() : new URL(ServiceUtil.getBasicService().getCodeBase(), location);
        boolean strict = null != Boot.getOption("-strict");
        JNLPFile file = new JNLPFile(url, strict);
        Boot.addProperties(file);
        if (file.isApplet()) {
            Boot.addParameters(file);
        }
        if (file.isApplication()) {
            Boot.addArguments(file);
        }
        if (JNLPRuntime.isDebug()) {
            if (Boot.getOption("-arg") != null && (file.isInstaller() || file.isApplet())) {
                System.out.println(Boot.R("BArgsNA"));
            }
            if (Boot.getOption("-param") != null && file.isApplication()) {
                System.out.println(Boot.R("BParamNA"));
            }
        }
        return file;
    }

    private static void addProperties(JNLPFile file) {
        String[] props = Boot.getOptions("-property");
        ResourcesDesc resources = file.getResources();
        for (int i = 0; i < props.length; ++i) {
            int equals = props[i].indexOf("=");
            if (equals == -1) {
                Boot.fatalError(Boot.R("BBadProp", props[i]));
            }
            String key = props[i].substring(0, equals);
            String value = props[i].substring(equals + 1, props[i].length());
            resources.addResource(new PropertyDesc(key, value));
        }
    }

    private static void addParameters(JNLPFile file) {
        String[] params = Boot.getOptions("-param");
        AppletDesc applet = file.getApplet();
        for (int i = 0; i < params.length; ++i) {
            int equals = params[i].indexOf("=");
            if (equals == -1) {
                Boot.fatalError(Boot.R("BBadParam", params[i]));
            }
            String name = params[i].substring(0, equals);
            String value = params[i].substring(equals + 1, params[i].length());
            applet.addParameter(name, value);
        }
    }

    private static void addArguments(JNLPFile file) {
        String[] args = Boot.getOptions("-arg");
        ApplicationDesc app = file.getApplication();
        for (int i = 0; i < args.length; ++i) {
            app.addArgument(args[i]);
        }
    }

    private static String getOption(String option) {
        String[] result = Boot.getOptions(option);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    private static String[] getOptions(String option) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (option.equals(args[i])) {
                if (-1 == doubleArgs.indexOf(option)) {
                    result.add(option);
                } else if (i + 1 < args.length) {
                    result.add(args[i + 1]);
                }
            }
            if (!args[i].startsWith("-") || -1 == doubleArgs.indexOf(args[i])) continue;
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static File getBaseDir() {
        if (Boot.getOption("-basedir") != null) {
            File basedir = new File(Boot.getOption("-basedir"));
            if (!basedir.exists() || !basedir.isDirectory()) {
                Boot.fatalError(Boot.R("BNoDir", basedir));
            }
            return basedir;
        }
        File basedir = JNLPRuntime.getDefaultBaseDir();
        if (basedir == null) {
            Boot.fatalError(Boot.R("BNoBase"));
        }
        return basedir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

