/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp.services;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;
import netx.jnlp.cache.CacheUtil;
import netx.jnlp.runtime.ApplicationInstance;
import netx.jnlp.runtime.JNLPRuntime;
import netx.jnlp.services.ServiceUtil;
import netx.jnlp.services.XFileContents;

class XPersistenceService
implements PersistenceService {
    static /* synthetic */ Class class$javax$jnlp$FileContents;

    protected XPersistenceService() {
    }

    protected void checkLocation(URL location) throws MalformedURLException {
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app == null) {
            throw new MalformedURLException("Cannot determine the current application.");
        }
        URL source = app.getJNLPFile().getCodeBase();
        if (!source.getHost().equalsIgnoreCase(location.getHost())) {
            throw new MalformedURLException("Cannot access data from a different host.");
        }
        String requestPath = location.getFile();
        requestPath = -1 != requestPath.lastIndexOf("/") ? requestPath.substring(0, requestPath.lastIndexOf("/")) : "";
        if (JNLPRuntime.isDebug()) {
            System.out.println("codebase path: " + source.getFile());
            System.out.println("request path: " + requestPath);
        }
        if (!source.getFile().startsWith(requestPath)) {
            throw new MalformedURLException("Cannot access data below source URL path.");
        }
    }

    protected File toCacheFile(URL location) throws MalformedURLException {
        return CacheUtil.urlToPath(location, "pcache");
    }

    public long create(URL location, long maxsize) throws MalformedURLException, IOException {
        this.checkLocation(location);
        File file = this.toCacheFile(location);
        file.getParentFile().mkdirs();
        if (!file.createNewFile()) {
            throw new IOException("File already exists.");
        }
        return maxsize;
    }

    public void delete(URL location) throws MalformedURLException, IOException {
        this.checkLocation(location);
        this.toCacheFile(location).delete();
    }

    public FileContents get(URL location) throws MalformedURLException, IOException, FileNotFoundException {
        this.checkLocation(location);
        File file = this.toCacheFile(location);
        file.getParentFile().mkdirs();
        return (FileContents)ServiceUtil.createPrivilegedProxy(class$javax$jnlp$FileContents == null ? (class$javax$jnlp$FileContents = XPersistenceService.class$("javax.jnlp.FileContents")) : class$javax$jnlp$FileContents, new XFileContents(file));
    }

    public String[] getNames(URL location) throws MalformedURLException, IOException {
        this.checkLocation(location);
        File file = this.toCacheFile(location);
        if (!file.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        File[] entries = file.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            if (!entries[i].isFile()) continue;
            result.add(entries[i].getName());
        }
        return result.toArray(new String[result.size()]);
    }

    public int getTag(URL location) throws MalformedURLException, IOException {
        this.checkLocation(location);
        if (this.toCacheFile(location).exists()) {
            return 0;
        }
        return 0;
    }

    public void setTag(URL location, int tag) throws MalformedURLException, IOException {
        this.checkLocation(location);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

