/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonFinalTransformer
implements ClassFileTransformer {
    public static void premain(String agentArgs, Instrumentation inst) {
        System.out.println("Installing non-final class transformer");
        inst.addTransformer(new NonFinalTransformer());
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className.startsWith("java/") || className.startsWith("javax/")) {
            return classfileBuffer;
        }
        ClassReader r = new ClassReader(classfileBuffer);
        ClassWriter cw = new ClassWriter(r, 0){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access &= 0xFFFFFFEF, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String method, String desc, String signature, String[] exceptions) {
                return super.visitMethod(access &= 0xFFFFFFEF, method, desc, signature, exceptions);
            }
        };
        r.accept(cw, 0);
        return cw.toByteArray();
    }
}

