/*
 * Decompiled with CFR 0.152.
 */
package org.suigeneris.jrcs.rcs.parse;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import org.suigeneris.jrcs.rcs.Archive;
import org.suigeneris.jrcs.rcs.ArchiveParseAdapter;
import org.suigeneris.jrcs.rcs.Version;
import org.suigeneris.jrcs.rcs.impl.Node;
import org.suigeneris.jrcs.rcs.parse.ArchiveParserConstants;
import org.suigeneris.jrcs.rcs.parse.ArchiveParserTokenManager;
import org.suigeneris.jrcs.rcs.parse.CharStream;
import org.suigeneris.jrcs.rcs.parse.FastCharStream;
import org.suigeneris.jrcs.rcs.parse.ParseException;
import org.suigeneris.jrcs.rcs.parse.Token;

public class ArchiveParser
implements ArchiveParserConstants {
    static final String ident = "RCS ArchiveParser Parser $version$:";
    public ArchiveParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;

    public static void load(Archive arc, CharStream input) throws ParseException {
        ArchiveParser parser = new ArchiveParser(input);
        parser.archive(arc);
    }

    public static void load(Archive arc, String fname) throws FileNotFoundException, ParseException {
        ArchiveParser.load(arc, new FastCharStream(new FileReader(fname)));
    }

    public void parse() {
        try {
            this.archive(null);
            System.out.println("RCS ArchiveParser Parser version 1.1:  RCS ArchiveParser parsed successfully.");
        }
        catch (ParseException e) {
            System.out.println("RCS ArchiveParser Parser version 1.1:  Encountered errors during parse.");
        }
    }

    public final void archive(Archive arc) throws ParseException {
        ArchiveParseAdapter adapter = new ArchiveParseAdapter(arc);
        this.admin(adapter);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            this.delta(adapter);
        }
        this.desc(arc);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            this.text(adapter);
        }
        this.jj_consume_token(0);
    }

    public final void admin(ArchiveParseAdapter arc) throws ParseException {
        this.head(arc);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.branch(arc.archive);
                break;
            }
        }
        this.access(arc.archive);
        this.symbols(arc.archive);
        this.locks(arc.archive);
        this.optionals(arc);
    }

    public final void optionals(ArchiveParseAdapter arc) throws ParseException {
        block9: {
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 13: 
                    case 22: {
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        this.comment(arc.archive);
                        continue block8;
                    }
                    case 13: {
                        this.expand(arc.archive);
                        continue block8;
                    }
                    case 22: {
                        this.newPhrase(arc.getPhrases());
                        continue block8;
                    }
                }
                break;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void newPhrases(Map map) throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.newPhrase(map);
        }
    }

    public final void head(ArchiveParseAdapter arc) throws ParseException {
        this.jj_consume_token(14);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                Version v = this.version();
                arc.setHead(v);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void branch(Archive arc) throws ParseException {
        this.jj_consume_token(8);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                Version v = this.version();
                arc.setBranch(v);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void access(Archive arc) throws ParseException {
        this.jj_consume_token(6);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String name = this.id();
            arc.addUser(name);
        }
        this.jj_consume_token(28);
    }

    public final void symbols(Archive arc) throws ParseException {
        this.jj_consume_token(20);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 23: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String s = this.sym();
            this.jj_consume_token(29);
            Version v = this.version();
            arc.addSymbol(s, v);
        }
        this.jj_consume_token(28);
    }

    public final void locks(Archive arc) throws ParseException {
        this.jj_consume_token(15);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    break block6;
                }
            }
            String name = this.id();
            this.jj_consume_token(29);
            Version v = this.version();
            arc.addLock(name, v);
        }
        this.jj_consume_token(28);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                this.jj_consume_token(28);
                arc.setStrictLocking(true);
                break;
            }
        }
    }

    public final void comment(Archive arc) throws ParseException {
        this.jj_consume_token(10);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                String s = this.string();
                arc.setComment(s);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void expand(Archive arc) throws ParseException {
        this.jj_consume_token(13);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                String s = this.string();
                arc.setExpand(s);
                break;
            }
        }
        this.jj_consume_token(28);
    }

    public final void newPhrase(Map map) throws ParseException {
        StringBuffer values = new StringBuffer();
        String key = this.id();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 26: 
                case 27: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            String value = this.word();
            values.append(" " + value);
        }
        this.jj_consume_token(28);
        if (map != null) {
            map.put(key, values.toString());
        }
    }

    public final String word() throws ParseException {
        String result = this.simpleWord();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                String right = this.range();
                result = result + right;
                break;
            }
        }
        return result;
    }

    public final String simpleWord() throws ParseException {
        String result;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                result = this.id();
                break;
            }
            case 26: {
                Version v = this.version();
                result = v.toString();
                break;
            }
            case 27: {
                result = this.string();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final String range() throws ParseException {
        this.jj_consume_token(29);
        String rightSide = this.simpleWord();
        return ":" + rightSide;
    }

    public final void desc(Archive arc) throws ParseException {
        this.jj_consume_token(12);
        String s = this.string();
        arc.setDesc(s);
    }

    public final void delta(ArchiveParseAdapter arc) throws ParseException {
        String name = "";
        Version v = this.version();
        Node node = arc.newNode(v);
        this.jj_consume_token(11);
        int[] d = this.date();
        node.setDate(d);
        this.jj_consume_token(28);
        this.jj_consume_token(7);
        name = this.authorName();
        node.setAuthor(name);
        this.jj_consume_token(28);
        this.jj_consume_token(18);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                String s = this.id();
                node.setState(s);
                break;
            }
        }
        this.jj_consume_token(28);
        this.jj_consume_token(9);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            v = this.version();
            node.addBranch(arc.newBranchNode(v));
        }
        this.jj_consume_token(28);
        this.jj_consume_token(17);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                v = this.version();
                node.setRCSNext(arc.newNode(v));
                break;
            }
        }
        this.jj_consume_token(28);
        this.newPhrases(node.getPhrases());
    }

    public final void text(ArchiveParseAdapter arc) throws ParseException {
        Version v = this.version();
        Node node = arc.getNode(v);
        this.jj_consume_token(16);
        String log = this.string();
        node.setLog(log);
        this.newPhrases(node.getPhrases());
        this.jj_consume_token(21);
        String txt = this.string();
        node.setText(txt);
    }

    public final String id() throws ParseException {
        Token t = this.jj_consume_token(22);
        return t.image;
    }

    public final String authorId() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            case 6: {
                t = this.jj_consume_token(6);
                break;
            }
            case 7: {
                t = this.jj_consume_token(7);
                break;
            }
            case 8: {
                t = this.jj_consume_token(8);
                break;
            }
            case 9: {
                t = this.jj_consume_token(9);
                break;
            }
            case 10: {
                t = this.jj_consume_token(10);
                break;
            }
            case 11: {
                t = this.jj_consume_token(11);
                break;
            }
            case 12: {
                t = this.jj_consume_token(12);
                break;
            }
            case 13: {
                t = this.jj_consume_token(13);
                break;
            }
            case 14: {
                t = this.jj_consume_token(14);
                break;
            }
            case 15: {
                t = this.jj_consume_token(15);
                break;
            }
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 19: {
                t = this.jj_consume_token(19);
                break;
            }
            case 20: {
                t = this.jj_consume_token(20);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final String authorName() throws ParseException {
        String name = "";
        block3: while (true) {
            String s = this.authorId();
            name = name + " " + s;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    continue block3;
                }
            }
            break;
        }
        return name.trim();
    }

    public final String sym() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final Version version() throws ParseException {
        int n = this.num();
        Version v = new Version(n);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 30: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.jj_consume_token(30);
            n = this.num();
            v.__addBranch(n);
        }
        return v;
    }

    public final int[] date() throws ParseException {
        int[] n = new int[6];
        n[0] = this.num();
        this.jj_consume_token(30);
        n[1] = this.num();
        this.jj_consume_token(30);
        n[2] = this.num();
        this.jj_consume_token(30);
        n[3] = this.num();
        this.jj_consume_token(30);
        n[4] = this.num();
        this.jj_consume_token(30);
        n[5] = this.num();
        return n;
    }

    public final int num() throws ParseException {
        Token t = this.jj_consume_token(26);
        return Integer.parseInt(t.image);
    }

    public final String string() throws ParseException {
        Token t = this.jj_consume_token(27);
        return Archive.unquoteString(t.image);
    }

    public ArchiveParser(CharStream stream) {
        this.token_source = new ArchiveParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(CharStream stream) {
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public ArchiveParser(ArchiveParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(ArchiveParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

