/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.scm.BlameSubversionSCM;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.tmatesoft.svn.core.SVNException;

public class BlameSubversionRepositoryStatus
extends AbstractModelObject {
    public final UUID uuid;
    private static final Logger LOGGER = Logger.getLogger(BlameSubversionRepositoryStatus.class.getName());

    public BlameSubversionRepositoryStatus(UUID uuid) {
        this.uuid = uuid;
    }

    public String getDisplayName() {
        return this.uuid.toString();
    }

    public String getSearchUrl() {
        return this.uuid.toString();
    }

    public void doNotifyCommit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        String line;
        this.requirePOST();
        HashSet<String> affectedPath = new HashSet<String>();
        BufferedReader r = new BufferedReader(req.getReader());
        while ((line = r.readLine()) != null) {
            LOGGER.finer("Reading line: " + line);
            affectedPath.add(line.substring(4));
            if (!line.startsWith("svnlook changed --revision ")) continue;
            String msg = "Expecting the output from the svnlook command but instead you just sent me the svnlook invocation command line: " + line;
            LOGGER.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Change reported to Subversion repository " + this.uuid + " on " + affectedPath);
        }
        boolean scmFound = false;
        boolean triggerFound = false;
        boolean uuidFound = false;
        boolean pathFound = false;
        block3: for (AbstractProject p : Hudson.getInstance().getItems(AbstractProject.class)) {
            try {
                SCM scm = p.getScm();
                if (!(scm instanceof BlameSubversionSCM)) continue;
                scmFound = true;
                SCMTrigger trigger = (SCMTrigger)p.getTrigger(SCMTrigger.class);
                if (trigger == null) continue;
                triggerFound = true;
                BlameSubversionSCM sscm = (BlameSubversionSCM)scm;
                for (BlameSubversionSCM.ModuleLocation loc : sscm.getLocations()) {
                    String n;
                    if (!loc.getUUID(p).equals(this.uuid)) continue;
                    uuidFound = true;
                    String m = loc.getSVNURL().getPath();
                    if (!m.startsWith(n = loc.getRepositoryRoot(p).getPath())) continue;
                    String remaining = m.substring(n.length());
                    if (remaining.startsWith("/")) {
                        remaining = remaining.substring(1);
                    }
                    String remainingSlash = remaining + '/';
                    for (String path : affectedPath) {
                        if (!path.equals(remaining) && !path.startsWith(remainingSlash)) continue;
                        LOGGER.fine("Scheduling the immediate polling of " + p);
                        trigger.run();
                        pathFound = true;
                        continue block3;
                    }
                }
            }
            catch (SVNException e) {
                LOGGER.log(Level.WARNING, "Failed to handle Subversion commit notification", e);
            }
        }
        if (!scmFound) {
            LOGGER.warning("No subversion jobs found");
        } else if (!triggerFound) {
            LOGGER.warning("No subversion jobs using SCM polling");
        } else if (!uuidFound) {
            LOGGER.warning("No subversion jobs using repository: " + this.uuid);
        } else if (!pathFound) {
            LOGGER.fine("No jobs found matching the modified files");
        }
        rsp.setStatus(200);
    }
}

