/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.XmlFile;
import hudson.model.AbstractProject;
import hudson.model.Saveable;
import hudson.remoting.Channel;
import hudson.scm.BlameSubversionSCM;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.SVNURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PerJobCredentialStore
implements Saveable,
BlameSubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider {
    private final transient AbstractProject<?, ?> project;
    private final Map<String, BlameSubversionSCM.DescriptorImpl.Credential> credentials = new Hashtable<String, BlameSubversionSCM.DescriptorImpl.Credential>();
    private static final Logger LOGGER = Logger.getLogger(PerJobCredentialStore.class.getName());

    PerJobCredentialStore(AbstractProject<?, ?> project) {
        this.project = project;
        XmlFile xml = this.getXmlFile();
        try {
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to retrieve Subversion credentials from " + xml, e);
        }
    }

    public synchronized BlameSubversionSCM.DescriptorImpl.Credential get(String realm) {
        return this.credentials.get(realm);
    }

    @Override
    public BlameSubversionSCM.DescriptorImpl.Credential getCredential(SVNURL url, String realm) {
        return this.get(realm);
    }

    @Override
    public void acknowledgeAuthentication(String realm, BlameSubversionSCM.DescriptorImpl.Credential cred) {
        try {
            this.acknowledge(realm, cred);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failed to persist the credentials", e);
        }
    }

    public synchronized void acknowledge(String realm, BlameSubversionSCM.DescriptorImpl.Credential cred) throws IOException {
        BlameSubversionSCM.DescriptorImpl.Credential old;
        BlameSubversionSCM.DescriptorImpl.Credential credential = old = cred == null ? this.credentials.remove(realm) : this.credentials.put(realm, cred);
        if (old == null && cred == null) {
            return;
        }
        if (old == null || cred == null || !old.equals(cred)) {
            this.save();
        }
    }

    public synchronized void save() throws IOException {
        this.getXmlFile().write((Object)this);
    }

    private XmlFile getXmlFile() {
        return new XmlFile(new File(this.project.getRootDir(), "subversion.credentials"));
    }

    private Object writeReplace() {
        Channel c = Channel.current();
        return c == null ? this : (BlameSubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider)c.export(BlameSubversionSCM.DescriptorImpl.RemotableSVNAuthenticationProvider.class, (Object)this);
    }
}

