/*
 * Decompiled with CFR 0.152.
 */
package hudson.notify;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.notify.HundredTimesBuildNumberSychronize;
import hudson.notify.SameBuildNumberSychronize;
import hudson.notify.TenTimesBuildNumberSychronize;
import hudson.notify.UpDownStreamNumberSychronizedNotify;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpDownStreamNumberSychronizedNotify
extends Notifier {
    protected static final Logger LOGGER = Logger.getLogger(UpDownStreamNumberSychronizedNotify.class.getName());
    private String times;
    private int itimes = 1;

    public String getTimes() {
        return this.times;
    }

    public void setTimes(String times) {
        this.times = times;
    }

    @DataBoundConstructor
    public UpDownStreamNumberSychronizedNotify(String times) {
        this.times = times;
        try {
            this.itimes = Integer.parseInt(times);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            SameBuildNumberSychronize buildNumberSychronize = null;
            switch (this.itimes) {
                case 1: {
                    buildNumberSychronize = new SameBuildNumberSychronize(build, listener);
                    break;
                }
                case 10: {
                    buildNumberSychronize = new TenTimesBuildNumberSychronize(build, listener);
                    break;
                }
                case 100: {
                    buildNumberSychronize = new HundredTimesBuildNumberSychronize(build, listener);
                    break;
                }
                default: {
                    buildNumberSychronize = new SameBuildNumberSychronize(build, listener);
                }
            }
            buildNumberSychronize.sychronizeBuildNumber();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public BuildNumberSychonizeDescriptorImpl getDescriptor() {
        return (BuildNumberSychonizeDescriptorImpl)super.getDescriptor();
    }
}

