/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.TaskThread;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.BlameSubversionSCM;
import hudson.scm.BlameSubversionTagAction;
import hudson.scm.UserProvidedCredential;
import hudson.scm.subversion.Messages;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class BlameSubversionTagAction
extends AbstractScmTagAction
implements Describable<BlameSubversionTagAction> {
    private final Map<BlameSubversionSCM.SvnInfo, List<String>> tags = new CopyOnWriteMap.Tree();
    private static final Pattern TRUNK_BRANCH_MARKER = Pattern.compile("/(trunk|branches)(/|$)");

    BlameSubversionTagAction(AbstractBuild build, Collection<BlameSubversionSCM.SvnInfo> svnInfos) {
        super(build);
        HashMap m = new HashMap();
        for (BlameSubversionSCM.SvnInfo si : svnInfos) {
            m.put(si, new ArrayList());
        }
        this.tags.putAll(m);
    }

    public boolean hasTags() {
        return this.isTagged();
    }

    public String getIconFileName() {
        if (!this.isTagged() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        List v;
        int nonNullTag = 0;
        Iterator i$ = this.tags.values().iterator();
        while (i$.hasNext() && ((v = (List)i$.next()).isEmpty() || ++nonNullTag <= 1)) {
        }
        if (nonNullTag == 0) {
            return Messages.SubversionTagAction_DisplayName_HasNoTag();
        }
        if (nonNullTag == 1) {
            return Messages.SubversionTagAction_DisplayName_HasATag();
        }
        return Messages.SubversionTagAction_DisplayName_HasTags();
    }

    public Map<BlameSubversionSCM.SvnInfo, List<String>> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Exported(name="tags")
    public List<TagInfo> getTagInfo() {
        ArrayList<TagInfo> data = new ArrayList<TagInfo>();
        for (Map.Entry e : this.tags.entrySet()) {
            String module = ((BlameSubversionSCM.SvnInfo)e.getKey()).toString();
            for (String url : (List)e.getValue()) {
                data.add(new TagInfo(module, url, null));
            }
        }
        return data;
    }

    public boolean isTagged() {
        for (List t : this.tags.values()) {
            if (t.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getTooltip() {
        String tag = null;
        for (List v : this.tags.values()) {
            for (String s : v) {
                if (tag != null) {
                    return Messages.SubversionTagAction_Tooltip();
                }
                tag = s;
            }
        }
        if (tag != null) {
            return Messages.SubversionTagAction_Tooltip_OneTag(tag);
        }
        return null;
    }

    public String makeTagURL(BlameSubversionSCM.SvnInfo si) {
        Matcher m = TRUNK_BRANCH_MARKER.matcher(si.url);
        if (!m.find()) {
            return null;
        }
        return si.url.substring(0, m.start()) + "/tags/" + this.getBuild().getProject().getName() + "-" + this.getBuild().getNumber();
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        HashMap<BlameSubversionSCM.SvnInfo, String> newTags = new HashMap<BlameSubversionSCM.SvnInfo, String>();
        int i = -1;
        for (BlameSubversionSCM.SvnInfo e : this.tags.keySet()) {
            if (this.tags.size() > 1 && parser.get("tag" + ++i) == null) continue;
            newTags.put(e, parser.get("name" + i));
        }
        UserProvidedCredential upc = null;
        if (parser.get("credential") != null) {
            upc = UserProvidedCredential.fromForm((StaplerRequest)req, (MultipartFormDataParser)parser);
        }
        new TagWorkerThread(this, newTags, upc, parser.get("comment")).start();
        rsp.sendRedirect(".");
    }

    public Permission getPermission() {
        return BlameSubversionSCM.TAG;
    }

    public Descriptor<BlameSubversionTagAction> getDescriptor() {
        return Hudson.getInstance().getDescriptorOrDie(this.getClass());
    }

    static /* synthetic */ Map access$100(BlameSubversionTagAction x0) {
        return x0.tags;
    }

    static /* synthetic */ TaskThread access$202(BlameSubversionTagAction x0, TaskThread x1) {
        x0.workerThread = x1;
        return x0.workerThread;
    }
}

