/*
 * Decompiled with CFR 0.152.
 */
package configurationslicing.timer;

import antlr.ANTLRException;
import configurationslicing.UnorderedStringSlicer;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimerSliceStringSlicer
extends UnorderedStringSlicer<AbstractProject<?, ?>> {
    public TimerSliceStringSlicer() {
        super(new TimerSliceSpec());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimerSliceSpec
    implements UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
        private static final String DISABLED = "(Disabled)";

        @Override
        public String getName() {
            return "Timer Trigger Slicer";
        }

        @Override
        public String getName(AbstractProject<?, ?> item) {
            return item.getName();
        }

        @Override
        public String getUrl() {
            return "timerslicestring";
        }

        @Override
        public List<String> getValues(AbstractProject<?, ?> item) {
            TimerTrigger trigger = (TimerTrigger)item.getTrigger(TimerTrigger.class);
            String[] cronspec = null;
            if (trigger != null) {
                cronspec = trigger.getSpec().split("\n");
            }
            if (cronspec == null || cronspec.length == 0) {
                cronspec = new String[]{DISABLED};
            }
            return Arrays.asList(cronspec);
        }

        @Override
        public List<AbstractProject<?, ?>> getWorkDomain() {
            return Hudson.getInstance().getItems(AbstractProject.class);
        }

        @Override
        public boolean setValues(AbstractProject<?, ?> item, Set<String> set) {
            if (set.isEmpty()) {
                return false;
            }
            TimerTrigger trigger = (TimerTrigger)item.getTrigger(TimerTrigger.class);
            boolean disabled = false;
            StringBuilder triggerspec = new StringBuilder();
            for (String line : set) {
                if (line.equals(DISABLED)) {
                    disabled = true;
                    continue;
                }
                triggerspec.append(line);
            }
            try {
                TimerTrigger newtrigger = null;
                if (!disabled) {
                    newtrigger = new TimerTrigger(triggerspec.toString());
                }
                if (trigger != null) {
                    item.removeTrigger(trigger.getDescriptor());
                }
                if (newtrigger != null) {
                    item.addTrigger((Trigger)newtrigger);
                }
                return true;
            }
            catch (ANTLRException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

