/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.hudson;

import hudson.model.Result;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class TCPConnection {
    private InetAddress server;
    private int port;
    private Socket socket;
    private BufferedReader reader;
    private PrintWriter writer;
    private String serverIdent;
    private static final String PING = "PING";

    public TCPConnection(String host, int port) throws UnknownHostException {
        this(InetAddress.getByName(host), port);
    }

    public TCPConnection(InetAddress server, int port) {
        this.server = server;
        this.port = port;
    }

    public synchronized void open() throws IOException {
        if (this.socket == null) {
            this.socket = new Socket(this.server, this.port);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintWriter(this.socket.getOutputStream(), true);
            this.serverIdent = this.reader.readLine();
        }
    }

    public synchronized void close() throws IOException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public String getServerIdent() {
        return this.serverIdent;
    }

    public boolean ping() throws IOException {
        this.writer.println("PING:");
        String resp = this.reader.readLine();
        return resp.toUpperCase().startsWith(PING);
    }

    public void sendResult(String buildName, Result result) {
        this.writer.println("NAME " + buildName);
        this.writer.println("RESULT " + result.toString());
        this.writer.println("QUIT");
    }
}

