/*
 * Decompiled with CFR 0.152.
 */
package com.ingenotech.hudson;

import com.ingenotech.hudson.LavaLampInstallation;
import com.ingenotech.hudson.TCPConnection;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LavaLampNotifier
extends Notifier
implements Serializable {
    private static final long serialVersionUID = 3019486479572911590L;
    private static final Logger LOG = Logger.getLogger(LavaLampNotifier.class.getName());
    private final String name;
    private final Boolean changesOnly;

    @DataBoundConstructor
    public LavaLampNotifier(String name, Boolean changesOnly) {
        this.name = name;
        if (changesOnly == null) {
            changesOnly = false;
        }
        this.changesOnly = changesOnly;
    }

    public String getName() {
        return this.name;
    }

    public boolean getChangesOnly() {
        return this.changesOnly;
    }

    public LavaLampInstallation getLavaLamp() {
        DescriptorImpl descr = this.getDescriptor();
        for (LavaLampInstallation i : descr.getInstallations()) {
            if (this.name == null || !this.name.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        LavaLampInstallation ll = this.getLavaLamp();
        Result result = build.getResult();
        Result prevResult = null;
        AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
        if (prevBuild != null) {
            prevResult = prevBuild.getResult();
        }
        if (result == prevResult && this.changesOnly.booleanValue()) {
            LOG.fine("perform() - changesOnly set and result unchanged");
            return true;
        }
        TCPConnection c = null;
        try {
            c = ll.newConnection();
            c.open();
            c.sendResult(build.getFullDisplayName(), result);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Failed to connect to LavaLamp server", ex);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException ix) {}
            }
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private LavaLampNotifier lamp;

        public DescriptorImpl() {
            super(LavaLampNotifier.class);
            this.load();
        }

        public String toString() {
            return "DescriptorImpl@" + Integer.toHexString(System.identityHashCode((Object)this)) + "[name=" + this.lamp.getName() + ",changes=" + this.lamp.getChangesOnly() + "]";
        }

        public String getDisplayName() {
            return "Lava Lamp Notifications";
        }

        public String getName() {
            if (this.lamp == null) {
                return null;
            }
            return this.lamp.getName();
        }

        public boolean getChangesOnly() {
            if (this.lamp == null) {
                return false;
            }
            return this.lamp.getChangesOnly();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public LavaLampInstallation[] getInstallations() {
            LavaLampInstallation[] ins = ((LavaLampInstallation.DescriptorImpl)Hudson.getInstance().getDescriptorByType(LavaLampInstallation.DescriptorImpl.class)).getInstallations();
            return ins;
        }

        public LavaLampNotifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (LavaLampNotifier)super.newInstance(req, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.lamp = this.newInstance(req, formData);
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            boolean found = false;
            for (LavaLampInstallation i : this.getInstallations()) {
                if (value == null || !value.equals(i.getName())) continue;
                found = true;
            }
            if (!found) {
                return FormValidation.error((String)("LavaLamp name:" + value + " not found in global config"));
            }
            return FormValidation.ok();
        }
    }
}

