/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.plugins.PerfPublisher.ParserXml;
import hudson.plugins.PerfPublisher.PerfPublisherParseException;
import hudson.plugins.PerfPublisher.Report.Report;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportReader {
    private Report report;
    private final transient PrintStream hudsonConsoleWriter;

    public ReportReader(URI is, PrintStream logger, Map<String, String> metrics) {
        this.hudsonConsoleWriter = logger;
        this.parse(is, metrics.values());
    }

    private void parse(URI is, Collection<String> metrics) {
        if (is == null) {
            throw new PerfPublisherParseException("Empty input stream");
        }
        if (this.report == null) {
            this.report = new Report();
        }
        try {
            ParserXml parseur = new ParserXml(is, metrics);
            parseur.parse();
            this.report = parseur.result();
        }
        catch (IOException e) {
            String errMsg = "[PerfPublisher] Problem parsing Performance report file";
            this.hudsonConsoleWriter.println(errMsg + ": " + e.getMessage());
            e.printStackTrace(this.hudsonConsoleWriter);
            throw new PerfPublisherParseException(errMsg, (Exception)e);
        }
        catch (ParserConfigurationException e) {
            String errMsg = "[PerfPublisher] Problem parsing Performance report file";
            this.hudsonConsoleWriter.println(errMsg + ": " + e.getMessage());
            e.printStackTrace(this.hudsonConsoleWriter);
            throw new PerfPublisherParseException(errMsg, (Exception)e);
        }
        catch (SAXException e) {
            String errMsg = "[PerfPublisher] Problem parsing Performance report file";
            this.hudsonConsoleWriter.println(errMsg + ": " + e.getMessage());
            e.printStackTrace(this.hudsonConsoleWriter);
            throw new PerfPublisherParseException(errMsg, (Exception)e);
        }
    }

    public Report getReport() {
        return this.report;
    }
}

