/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.Action;
import hudson.plugins.PerfPublisher.AbstractPerfPublisherAction;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.matrixBuild.PerfPublisherMatrixBuild;
import hudson.plugins.PerfPublisher.matrixBuild.PerfPublisherMatrixSubBuild;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixTestReportAction
extends AbstractPerfPublisherAction
implements Action {
    PerfPublisherMatrixBuild matrixbuild;
    private int numberOfExecutedTest;
    private int numberOfTest;
    private int numberOfPassedTest;
    private int numberOfNotExecutedTest;
    private int numberOfTrueFalseTest;
    private int numberOfFailedTest;
    private MatrixBuild build;
    private MatrixProject project;

    public MatrixTestReportAction(MatrixBuild build) {
        this.matrixbuild = new PerfPublisherMatrixBuild(build.getNumber());
        this.build = build;
        this.project = (MatrixProject)build.getProject();
    }

    public MatrixBuild getBuild() {
        return this.build;
    }

    public MatrixProject getProject() {
        return this.project;
    }

    @Override
    public String getDisplayName() {
        return "Matrix build test report";
    }

    public String getSearchUrl() {
        return "PerfPublisher";
    }

    @Override
    public String getIconFileName() {
        return "graph.gif";
    }

    @Override
    public String getUrlName() {
        return "PerfPublisher";
    }

    public void addSubBuildResult(ReportContainer report, Map<String, String> buildVariables) {
        TreeMap<String, String> buildVars = new TreeMap<String, String>();
        buildVars.putAll(buildVariables);
        this.matrixbuild.addSubBuild(new PerfPublisherMatrixSubBuild(buildVars, report));
        this.computeStats();
    }

    public PerfPublisherMatrixBuild getMatrixBuild() {
        return this.matrixbuild;
    }

    public void computeStats() {
        this.numberOfExecutedTest = 0;
        this.numberOfFailedTest = 0;
        this.numberOfTest = 0;
        this.numberOfPassedTest = 0;
        this.numberOfTrueFalseTest = 0;
        List<PerfPublisherMatrixSubBuild> subBuilds = this.matrixbuild.getSubBuilds();
        for (int i = 0; i < subBuilds.size(); ++i) {
            this.numberOfExecutedTest += subBuilds.get(i).getReport().getNumberOfExecutedTest();
            this.numberOfFailedTest += subBuilds.get(i).getReport().getNumberOfFailedTest();
            this.numberOfTest += subBuilds.get(i).getReport().getNumberOfTest();
            this.numberOfPassedTest += subBuilds.get(i).getReport().getNumberOfPassedTest();
            this.numberOfTrueFalseTest = (int)((double)this.numberOfTrueFalseTest + subBuilds.get(i).getReport().getNumberOfTrueFalseTest());
        }
    }

    public String getSummary() {
        StringBuilder strbuilder = new StringBuilder();
        strbuilder.append("<div class=\"progress-container\">");
        int tmp1 = this.getNumberOfFailedTest();
        int tmp2 = this.getNumberOfPassedTest();
        double tmp3 = this.getPercentOfFailedTest();
        double tmp4 = this.getPercentOfPassedTest();
        if (tmp3 < 15.0) {
            strbuilder.append("<div id=\"red\" style=\"width:15%;\">" + tmp1 + "</div>");
            strbuilder.append("<div id=\"blue\" style=\"width:85%;\">" + tmp2 + "</div>");
        } else {
            strbuilder.append("<div id=\"red\" style=\"width:" + tmp3 + "%;\">" + tmp3 + "% (" + tmp1 + ")</div>");
            strbuilder.append("<div id=\"blue\" style=\"width:" + tmp4 + "%;\">" + tmp4 + "% (" + tmp2 + ")</div>");
        }
        strbuilder.append("</div>");
        return strbuilder.toString();
    }

    private int getNumberOfFailedTest() {
        return this.numberOfFailedTest;
    }

    private int getNumberOfPassedTest() {
        return this.numberOfPassedTest;
    }

    private int getNumberOfTrueFalseTest() {
        return this.numberOfTrueFalseTest;
    }

    private double getPercentOfFailedTest() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfFailedTest() / (double)this.getNumberOfTrueFalseTest() * 100.0;
        return MatrixTestReportAction.floor(resultat, 2);
    }

    private double getPercentOfPassedTest() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfPassedTest() / (double)this.getNumberOfTrueFalseTest() * 100.0;
        return MatrixTestReportAction.floor(resultat, 2);
    }

    public static double floor(double a, int n) {
        double p = Math.pow(10.0, n);
        return Math.floor(a * p + 0.5) / p;
    }

    public String getDetailSummary() {
        StringBuilder strbuilder = new StringBuilder();
        strbuilder.append("Number of executed tests : <b>" + this.getNumberOfExecutedTest() + ".</b>");
        strbuilder.append("<br />");
        return strbuilder.toString();
    }

    public String getHtmlArrayDisplay() {
        StringBuilder strb = new StringBuilder();
        strb.append("<table class=\"matrix_table\">\n");
        strb.append(this.generateHtmlArrayHeader());
        strb.append(this.generateHtmlArrayContent());
        strb.append("</table>");
        return strb.toString();
    }

    private String generateHtmlArrayContent() {
        StringBuilder strb = new StringBuilder();
        List<PerfPublisherMatrixSubBuild> subBuilds = this.matrixbuild.getSubBuilds();
        Collections.sort(subBuilds);
        HashMap<String, List<Integer>> values = new HashMap<String, List<Integer>>();
        for (int i = 0; i < subBuilds.size(); ++i) {
            List<Integer> nbs;
            if (values.containsKey("Nb tests")) {
                nbs = (List)values.get("Nb tests");
                nbs.add(subBuilds.get(i).getReport().getNumberOfTest());
            } else {
                nbs = new ArrayList();
                nbs.add(subBuilds.get(i).getReport().getNumberOfTest());
                values.put("Nb tests", nbs);
            }
            if (values.containsKey("Nb Executed tests")) {
                nbs = (List)values.get("Nb Executed tests");
                nbs.add(subBuilds.get(i).getReport().getNumberOfExecutedTest());
            } else {
                nbs = new ArrayList();
                nbs.add(subBuilds.get(i).getReport().getNumberOfExecutedTest());
                values.put("Nb Executed tests", nbs);
            }
            if (values.containsKey("Nb not executed tests")) {
                nbs = (List)values.get("Nb not executed tests");
                nbs.add(subBuilds.get(i).getReport().getNumberOfNotExecutedTest());
            } else {
                nbs = new ArrayList();
                nbs.add(subBuilds.get(i).getReport().getNumberOfNotExecutedTest());
                values.put("Nb not executed tests", nbs);
            }
            if (values.containsKey("Succeeded tests")) {
                nbs = (List)values.get("Succeeded tests");
                nbs.add(subBuilds.get(i).getReport().getNumberOfPassedTest());
            } else {
                nbs = new ArrayList();
                nbs.add(subBuilds.get(i).getReport().getNumberOfPassedTest());
                values.put("Succeeded tests", nbs);
            }
            if (values.containsKey("Failed tests")) {
                nbs = (List)values.get("Failed tests");
                nbs.add(subBuilds.get(i).getReport().getNumberOfFailedTest());
            } else {
                nbs = new ArrayList();
                nbs.add(subBuilds.get(i).getReport().getNumberOfFailedTest());
                values.put("Failed tests", nbs);
            }
            if (values.containsKey("Avg Compile time")) {
                nbs = (List)values.get("Avg Compile time");
                nbs.add((int)subBuilds.get(i).getReport().getAverageOfCompileTime());
            } else {
                nbs = new ArrayList();
                nbs.add((int)subBuilds.get(i).getReport().getAverageOfCompileTime());
                values.put("Avg Compile time", nbs);
            }
            if (values.containsKey("Avg Execution time")) {
                nbs = (List)values.get("Avg Execution time");
                nbs.add((int)subBuilds.get(i).getReport().getAverageOfExecutionTime());
            } else {
                nbs = new ArrayList();
                nbs.add((int)subBuilds.get(i).getReport().getAverageOfExecutionTime());
                values.put("Avg Execution time", nbs);
            }
            if (values.containsKey("Avg Performance")) {
                nbs = (List)values.get("Avg Performance");
                nbs.add((int)subBuilds.get(i).getReport().getAverageOfPerformance());
                continue;
            }
            nbs = new ArrayList();
            nbs.add((int)subBuilds.get(i).getReport().getAverageOfPerformance());
            values.put("Avg Performance", nbs);
        }
        strb.append(this.generateHtmlContentRow(values));
        return strb.toString();
    }

    private String generateHtmlContentRow(Map<String, List<Integer>> values) {
        StringBuilder strb = new StringBuilder();
        Set<Map.Entry<String, List<Integer>>> entry = values.entrySet();
        Iterator<Map.Entry<String, List<Integer>>> iterator = entry.iterator();
        int zebra = 2;
        while (iterator.hasNext()) {
            Map.Entry<String, List<Integer>> axe = iterator.next();
            strb.append("<tr class=\"zebra" + zebra + "\">\n");
            strb.append("<td class=\"header\"><small>" + axe.getKey() + "</small></td>\n");
            ArrayList<Integer> i_min = new ArrayList<Integer>();
            int tmp_min = 0;
            ArrayList<Integer> i_max = new ArrayList<Integer>();
            int tmp_max = 0;
            for (int i = 0; i < axe.getValue().size(); ++i) {
                for (int j = 0; j < axe.getValue().size(); ++j) {
                    if (j == 0) {
                        tmp_min = axe.getValue().get(j);
                        tmp_max = axe.getValue().get(j);
                        i_min.add(j);
                        i_max.add(j);
                        continue;
                    }
                    if (tmp_min > axe.getValue().get(j)) {
                        tmp_min = axe.getValue().get(j);
                        i_min = new ArrayList();
                        i_min.add(j);
                    }
                    if (tmp_max < axe.getValue().get(j)) {
                        tmp_max = axe.getValue().get(j);
                        i_max = new ArrayList();
                        i_max.add(j);
                    }
                    if (tmp_min == axe.getValue().get(j)) {
                        i_min.add(j);
                    }
                    if (tmp_max != axe.getValue().get(j)) continue;
                    i_max.add(j);
                }
                if (i_min.contains(i)) {
                    strb.append("<td class=\"min\">" + axe.getValue().get(i) + "</td>");
                    continue;
                }
                if (i_max.contains(i)) {
                    strb.append("<td class=\"max\">" + axe.getValue().get(i) + "</td>");
                    continue;
                }
                strb.append("<td>" + axe.getValue().get(i) + "</td>");
            }
            strb.append("</tr>\n");
            if (zebra == 1) {
                zebra = 2;
                continue;
            }
            zebra = 1;
        }
        return strb.toString();
    }

    private String generateHtmlArrayHeader() {
        StringBuilder strb = new StringBuilder();
        int factor = 1;
        int colspan = this.matrixbuild.getNbCombinations();
        for (int i_row = 0; i_row < this.matrixbuild.getNbAxis(); ++i_row) {
            strb.append("<tr>");
            String axis = this.matrixbuild.getAxis().get(i_row);
            strb.append("<td class=\"axe\">" + axis + "</td>\n");
            List<String> values = this.matrixbuild.getAxisValues(axis);
            Collections.sort(values);
            colspan /= values.size();
            for (int i_factor = 0; i_factor < factor; ++i_factor) {
                for (int i_value = 0; i_value < values.size(); ++i_value) {
                    if (colspan > 1) {
                        strb.append("<td COLSPAN=" + colspan + " class=\"axe_value\">" + values.get(i_value) + "</td>");
                        continue;
                    }
                    strb.append("<td class=\"axe_value\">" + values.get(i_value) + "</td>\n");
                }
            }
            factor *= values.size();
            strb.append("</tr>\n");
        }
        return strb.toString();
    }

    public int getNumberOfExecutedTest() {
        return this.numberOfExecutedTest;
    }
}

