/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher.Report;

import hudson.plugins.PerfPublisher.Report.CompileTime;
import hudson.plugins.PerfPublisher.Report.Test;
import java.util.ArrayList;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Report {
    private String categorie;
    private String name;
    private String startDate;
    private String startDateFormat;
    private String startTime;
    private String startTimeFormat;
    private String endDate;
    private String endDateFormat;
    private String endTime;
    private String endTimeFormat;
    private String file;
    private ArrayList<Test> tests = new ArrayList();
    private ArrayList<Test> executedTests = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getEndDateFormat() {
        return this.endDateFormat;
    }

    public void setEndDateFormat(String endDateFormat) {
        this.endDateFormat = endDateFormat;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getEndTimeFormat() {
        return this.endTimeFormat;
    }

    public void setEndTimeFormat(String endTimeFormat) {
        this.endTimeFormat = endTimeFormat;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ArrayList<Test> getTests() {
        return this.tests;
    }

    public void setTests(ArrayList<Test> tests) {
        for (int i = 0; i < tests.size(); ++i) {
            if (!tests.get(i).isExecuted()) continue;
            this.executedTests.add(tests.get(i));
        }
        this.tests = tests;
    }

    public void addTest(Test test) {
        this.tests.add(test);
        if (test.isExecuted()) {
            this.executedTests.add(test);
        }
    }

    public String getCategorie() {
        return this.categorie;
    }

    public void setCategorie(String categorie) {
        this.categorie = categorie;
    }

    public String getStartDateFormat() {
        return this.startDateFormat;
    }

    public void setStartDateFormat(String startDateFormat) {
        this.startDateFormat = startDateFormat;
    }

    public String getStartTimeFormat() {
        return this.startTimeFormat;
    }

    public void setStartTimeFormat(String startTimeFormat) {
        this.startTimeFormat = startTimeFormat;
    }

    public int getNumberOfTest() {
        int result = 0;
        for (int i = 0; i < this.tests.size(); ++i) {
            ++result;
        }
        return result;
    }

    public ArrayList<Test> getExecutedTests() {
        if (this.executedTests == null || this.executedTests.size() == 0) {
            this.executedTests = new ArrayList();
            for (int i = 0; i < this.tests.size(); ++i) {
                if (!this.tests.get(i).isExecuted()) continue;
                this.executedTests.add(this.tests.get(i));
            }
        }
        return this.executedTests;
    }

    public ArrayList<Test> getNotExecutedTests() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.tests.size(); ++i) {
            if (this.tests.get(i).isExecuted()) continue;
            result.add(this.tests.get(i));
        }
        return result;
    }

    public int getNumberOfNotExecutedTest() {
        return this.getNotExecutedTests().size();
    }

    public int getNumberOfExecutedTest() {
        return this.getExecutedTests().size();
    }

    public double getPercentOfExecutedTest() {
        double resultat = 0.0;
        resultat = (double)this.getNumberOfExecutedTest() / (double)this.getNumberOfTest() * 100.0;
        return Report.floor(resultat, 2);
    }

    public int getNumberofNotExecutedTest() {
        return this.getNumberOfTest() - this.getNumberOfExecutedTest();
    }

    public double getPercentOfNotExecutedTest() {
        return 100.0 - this.getPercentOfExecutedTest();
    }

    public int getNumberofPassedTest() {
        int result = 0;
        for (int i = 0; i < this.getNumberOfExecutedTest(); ++i) {
            if (!this.getExecutedTests().get(i).isSuccessfull()) continue;
            ++result;
        }
        return result;
    }

    public double getPercentofPassedTest() {
        double resultat = 0.0;
        resultat = (double)this.getNumberofPassedTest() / (double)this.getNumberOfExecutedTest() * 100.0;
        return Report.floor(resultat, 2);
    }

    public int getNumberofFailedTest() {
        int result = 0;
        for (int i = 0; i < this.getNumberOfExecutedTest(); ++i) {
            if (this.getExecutedTests().get(i).isSuccessfull()) continue;
            ++result;
        }
        return result;
    }

    public double getPercentofFailedTest() {
        return 100.0 - this.getPercentofPassedTest();
    }

    public ArrayList<Test> getTestsWithCompileTime() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.getNumberOfExecutedTest(); ++i) {
            if (!this.getExecutedTests().get(i).isCompileTime()) continue;
            result.add(this.getExecutedTests().get(i));
        }
        return result;
    }

    public int getNumberOfcompileTime() {
        return this.getTestsWithCompileTime().size();
    }

    public double getAverageOfcompileTime() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfcompileTime(); ++i) {
            result += this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
        }
        return result /= (double)this.getNumberOfcompileTime();
    }

    public Test getBestCompileTimeTest() {
        Test test = new Test();
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfcompileTime(); ++i) {
            if (i == 0) {
                result = this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
                test = this.getTestsWithCompileTime().get(i);
                continue;
            }
            if (!(result > this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure())) continue;
            result = this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
            test = this.getTestsWithCompileTime().get(i);
        }
        return test;
    }

    public CompileTime getBestCompileTime() {
        return this.getBestCompileTimeTest().getCompileTime();
    }

    public double getBestCompileTimeTestValue() {
        return this.getBestCompileTimeTest().getCompileTime().getMeasure();
    }

    public String getBestCompileTimeTestName() {
        return this.getBestCompileTimeTest().getName();
    }

    public String getWorstCompileTimeTestName() {
        String result = "";
        double temp = 0.0;
        for (int i = 0; i < this.getNumberOfcompileTime(); ++i) {
            if (i == 0) {
                temp = this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
                result = this.getTestsWithCompileTime().get(i).getName();
                continue;
            }
            if (!(temp < this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure())) continue;
            temp = this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
            result = this.getTestsWithCompileTime().get(i).getName();
        }
        return result;
    }

    public double getWorstCompileTimeTestValue() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfcompileTime(); ++i) {
            if (i == 0) {
                result = this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
                continue;
            }
            if (!(result < this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure())) continue;
            result = this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
        }
        return result;
    }

    public double getInfStandardDeviationOfCompileTimeAverage() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfcompileTime(); ++i) {
            if (!(result < this.getAverageOfcompileTime() - this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure())) continue;
            result = this.getAverageOfcompileTime() - this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure();
        }
        return result;
    }

    public double getSupStandardDeviationOfCompileTimeAverage() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfcompileTime(); ++i) {
            if (!(result < this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure() - this.getAverageOfcompileTime())) continue;
            result = this.getTestsWithCompileTime().get(i).getCompileTime().getMeasure() - this.getAverageOfcompileTime();
        }
        return result;
    }

    public ArrayList<Test> getTestsWithExecutionTime() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.getNumberOfExecutedTest(); ++i) {
            if (!this.getExecutedTests().get(i).isExecutionTime()) continue;
            result.add(this.getExecutedTests().get(i));
        }
        return result;
    }

    public int getNumberOfExecutionTime() {
        return this.getTestsWithExecutionTime().size();
    }

    public double getAverageOfExecutionTime() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTime(); ++i) {
            result += this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
        }
        return result /= (double)this.getNumberOfExecutionTime();
    }

    public String getWorstExecutionTimeTestName() {
        String result = "";
        double temp = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTime(); ++i) {
            if (i == 0) {
                temp = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
                result = this.getTestsWithExecutionTime().get(i).getName();
                continue;
            }
            if (!(temp < this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure())) continue;
            temp = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
            result = this.getTestsWithExecutionTime().get(i).getName();
        }
        return result;
    }

    public double getWorstExecutionTimeTestValue() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTime(); ++i) {
            if (i == 0) {
                result = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
                continue;
            }
            if (!(result < this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure())) continue;
            result = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
        }
        return result;
    }

    public String getBestExecutionTimeTestName() {
        String result = "";
        double temp = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTime(); ++i) {
            if (i == 0) {
                temp = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
                result = this.getTestsWithExecutionTime().get(i).getName();
                continue;
            }
            if (!(temp > this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure())) continue;
            temp = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
            result = this.getTestsWithExecutionTime().get(i).getName();
        }
        return result;
    }

    public double getBestExecutionTimeTestValue() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTime(); ++i) {
            if (i == 0) {
                result = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
                continue;
            }
            if (!(result > this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure())) continue;
            result = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
        }
        return result;
    }

    public double getInfStandardDeviationOfExecutionTimeAverage() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTime(); ++i) {
            if (!(result < this.getAverageOfExecutionTime() - this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure())) continue;
            result = this.getAverageOfExecutionTime() - this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure();
        }
        return result;
    }

    public double getSupStandardDeviationOfExecutionTimeAverage() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfExecutionTime(); ++i) {
            if (!(result < this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure() - this.getAverageOfExecutionTime())) continue;
            result = this.getTestsWithExecutionTime().get(i).getExecutionTime().getMeasure() - this.getAverageOfExecutionTime();
        }
        return result;
    }

    public ArrayList<Test> getTestsWithPerformance() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.getNumberOfExecutedTest(); ++i) {
            if (!this.getExecutedTests().get(i).isPerformance()) continue;
            result.add(this.getExecutedTests().get(i));
        }
        return result;
    }

    public int getNumberOfPerformance() {
        return this.getTestsWithPerformance().size();
    }

    public ArrayList<Test> getTestsWithSuccess() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (int i = 0; i < this.getNumberOfExecutedTest(); ++i) {
            if (!this.getExecutedTests().get(i).isSuccess()) continue;
            result.add(this.getExecutedTests().get(i));
        }
        return result;
    }

    public int getNumberOfSuccess() {
        return this.getTestsWithSuccess().size();
    }

    public double getAverageOfPerformance() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfPerformance(); ++i) {
            result += this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
        }
        return result /= (double)this.getNumberOfPerformance();
    }

    public String getBestPerformanceTestName() {
        String result = "";
        double temp = 0.0;
        for (int i = 0; i < this.getNumberOfPerformance(); ++i) {
            if (i == 0) {
                temp = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
                result = this.getTestsWithPerformance().get(i).getName();
                continue;
            }
            if (!(temp < this.getTestsWithPerformance().get(i).getPerformance().getMeasure())) continue;
            temp = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
            result = this.getTestsWithPerformance().get(i).getName();
        }
        return result;
    }

    public double getBestPerformanceTestValue() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfPerformance(); ++i) {
            if (i == 0) {
                result = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
                continue;
            }
            if (!(result < this.getTestsWithPerformance().get(i).getPerformance().getMeasure())) continue;
            result = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
        }
        return result;
    }

    public String getWorstPerformanceTestName() {
        String result = "";
        double temp = 0.0;
        for (int i = 0; i < this.getNumberOfPerformance(); ++i) {
            if (i == 0) {
                temp = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
                result = this.getTestsWithPerformance().get(i).getName();
                continue;
            }
            if (!(temp > this.getTestsWithPerformance().get(i).getPerformance().getMeasure())) continue;
            temp = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
            result = this.getTestsWithPerformance().get(i).getName();
        }
        return result;
    }

    public double getWorstPerformanceTestValue() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfPerformance(); ++i) {
            if (i == 0) {
                result = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
                continue;
            }
            if (!(result > this.getTestsWithPerformance().get(i).getPerformance().getMeasure())) continue;
            result = this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
        }
        return result;
    }

    public double getInfStandardDeviationOfPerformanceAverage() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfPerformance(); ++i) {
            if (!(result < this.getAverageOfPerformance() - this.getTestsWithPerformance().get(i).getPerformance().getMeasure())) continue;
            result = this.getAverageOfPerformance() - this.getTestsWithPerformance().get(i).getPerformance().getMeasure();
        }
        return result;
    }

    public double getSupStandardDeviationOfPerformanceAverage() {
        double result = 0.0;
        for (int i = 0; i < this.getNumberOfPerformance(); ++i) {
            if (!(result < this.getTestsWithPerformance().get(i).getPerformance().getMeasure() - this.getAverageOfPerformance())) continue;
            result = this.getTestsWithPerformance().get(i).getPerformance().getMeasure() - this.getAverageOfPerformance();
        }
        return result;
    }

    public static double floor(double a, int n) {
        double p = Math.pow(10.0, n);
        return Math.floor(a * p + 0.5) / p;
    }

    public int getDuration() {
        int resultat = 0;
        GregorianCalendar calendar_endDate = new GregorianCalendar();
        calendar_endDate.set(Integer.parseInt(this.getEndDate().substring(0, 4)), Integer.parseInt(this.getEndDate().substring(4, 6)), Integer.parseInt(this.getEndDate().substring(6, 8)), Integer.parseInt(this.getEndDate().substring(0, 2)), Integer.parseInt(this.getEndDate().substring(2, 4)), Integer.parseInt(this.getEndDate().substring(4, 6)));
        GregorianCalendar calendar_startDate = new GregorianCalendar();
        calendar_startDate.set(Integer.parseInt(this.getStartDate().substring(0, 4)), Integer.parseInt(this.getStartDate().substring(4, 6)), Integer.parseInt(this.getStartDate().substring(6, 8)), Integer.parseInt(this.getStartDate().substring(0, 2)), Integer.parseInt(this.getStartDate().substring(2, 4)), Integer.parseInt(this.getStartDate().substring(4, 6)));
        return resultat;
    }

    public String toString() {
        String resultat = null;
        resultat = "Categorie : " + this.categorie;
        resultat = resultat + "\nName : " + this.name;
        resultat = resultat + "\nStart date (" + this.startDateFormat + ") : " + this.startDate;
        resultat = resultat + "\nStart time (" + this.startTimeFormat + ") : " + this.startTime;
        resultat = resultat + "\n----------------------------------------------";
        for (int i = 0; i < this.tests.size(); ++i) {
            resultat = resultat + "\n----------------------------------------------";
            resultat = resultat + "\nTest name : " + this.tests.get(i).getName();
            for (int j = 0; j < this.tests.get(i).getCommandLine().size(); ++j) {
                resultat = resultat + "\nCommand line : " + this.tests.get(i).getCommandLine().get(j).getCommand() + " (" + this.tests.get(i).getCommandLine().get(j).getTime() + ")";
            }
            resultat = resultat + "\nState success : " + this.tests.get(i).getSuccess().getState();
        }
        return resultat;
    }

    public int getNumberOfSuccessTest() {
        return this.getTestsWithSuccess().size();
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Test getTestWithName(String testName) {
        for (int i = 0; i < this.getNumberOfTest(); ++i) {
            if (!this.getTests().get(i).getName().equals(testName)) continue;
            return this.getTests().get(i);
        }
        return null;
    }
}

