/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher.Report;

import hudson.plugins.PerfPublisher.Report.CommandLine;
import hudson.plugins.PerfPublisher.Report.CompileTime;
import hudson.plugins.PerfPublisher.Report.DataSet;
import hudson.plugins.PerfPublisher.Report.ExecutionTime;
import hudson.plugins.PerfPublisher.Report.Log;
import hudson.plugins.PerfPublisher.Report.Param;
import hudson.plugins.PerfPublisher.Report.Performance;
import hudson.plugins.PerfPublisher.Report.Platform;
import hudson.plugins.PerfPublisher.Report.Source;
import hudson.plugins.PerfPublisher.Report.Success;
import hudson.plugins.PerfPublisher.Report.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test
implements Comparable<Test> {
    private String name;
    private String description;
    private ArrayList<Target> targets;
    private String message;
    private boolean executed;
    private ArrayList<Source> sources;
    private DataSet dataSetIn;
    private DataSet dataSetOut;
    private ArrayList<CommandLine> commandLine;
    private ArrayList<Param> parameters;
    private Success success;
    private CompileTime compileTime;
    private ExecutionTime executionTime;
    private Performance performance;
    private List<Log> logs;
    private Platform plateforme;
    private boolean isPerformance;
    private boolean isCompileTime;
    private boolean isExecutionTime;
    private boolean isSuccess;
    private Map<String, Double> metrics;

    public Test() {
        this.targets = new ArrayList();
        this.sources = new ArrayList();
        this.commandLine = new ArrayList();
        this.parameters = new ArrayList();
        this.success = new Success();
        this.compileTime = new CompileTime();
        this.executionTime = new ExecutionTime();
        this.performance = new Performance();
        this.logs = new ArrayList<Log>();
        this.metrics = new HashMap<String, Double>();
    }

    public Test(String name, String message, String description, boolean executed, ArrayList<Source> sources, DataSet dataSetIn, DataSet dataSetOut, ArrayList<CommandLine> commandLine, ArrayList<Param> parameters, Success success, CompileTime compileTime, ExecutionTime executionTime, Performance performance) {
        this.name = name;
        this.message = message;
        this.description = description;
        this.executed = executed;
        this.sources = sources;
        this.dataSetIn = dataSetIn;
        this.dataSetOut = dataSetOut;
        this.commandLine = commandLine;
        this.parameters = parameters;
        this.success = success;
        this.compileTime = compileTime;
        this.executionTime = executionTime;
        this.performance = performance;
        this.targets = new ArrayList();
    }

    public String getMessage() {
        return this.message;
    }

    public String getShortedMessage() {
        if (this.message == null || this.message.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        String tmp = this.message;
        while (tmp.length() > 90) {
            result.append(tmp.substring(0, 90));
            result.append("<br />");
            tmp = tmp.substring(90);
        }
        result.append(tmp);
        return result.toString();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public String getAdaptedName() {
        if (this.name == null || this.name.isEmpty()) {
            return this.name;
        }
        StringBuilder result = new StringBuilder();
        if (this.name.length() > 60) {
            result.append(this.name.substring(0, 27));
            result.append("[...]");
            result.append(this.name.substring(this.name.length() - 27, this.name.length()));
            result.append("<span>");
            result.append(this.name);
            result.append("</span>");
        } else {
            result.append(this.name);
        }
        return result.toString();
    }

    public String getNameForUrl() {
        String result = this.name.replace("/", "..");
        return result;
    }

    public static String ResolveTestNameInUrl(String name) {
        String result = name.replace("..", "/");
        return result;
    }

    public ArrayList<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(ArrayList<Target> targets) {
        this.targets = targets;
    }

    public void addTarget(Target target) {
        this.targets.add(target);
    }

    public String getHtmlDefinitionOfTargets() {
        StringBuilder strb = new StringBuilder();
        strb.append("<small>");
        for (int i = 0; i < this.targets.size(); ++i) {
            strb.append("<b>" + this.targets.get(i).getName() + "</b>");
            if (i >= this.targets.size() - 1) continue;
            strb.append("-");
        }
        strb.append("</small>");
        return strb.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public void setLogs(List<Log> logs) {
        this.logs = logs;
    }

    public void addLog(Log log) {
        this.logs.add(log);
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public ArrayList<Source> getSources() {
        return this.sources;
    }

    public void addSource(Source source) {
        this.sources.add(source);
    }

    public void setSources(ArrayList<Source> sources) {
        this.sources = sources;
    }

    public DataSet getDataSetIn() {
        return this.dataSetIn;
    }

    public void setDataSetIn(DataSet dataSetIn) {
        this.dataSetIn = dataSetIn;
    }

    public DataSet getDataSetOut() {
        return this.dataSetOut;
    }

    public void setDataSetOut(DataSet dataSetOut) {
        this.dataSetOut = dataSetOut;
    }

    public ArrayList<CommandLine> getCommandLine() {
        return this.commandLine;
    }

    public void addCommandLine(CommandLine cmdLine) {
        this.commandLine.add(cmdLine);
    }

    public void setCommandLine(ArrayList<CommandLine> commandLine) {
        this.commandLine = commandLine;
    }

    public ArrayList<Param> getParameters() {
        return this.parameters;
    }

    public void addParameter(Param param) {
        this.parameters.add(param);
    }

    public void setParameters(ArrayList<Param> parameters) {
        this.parameters = parameters;
    }

    public Success getSuccess() {
        return this.success;
    }

    public void setSuccess(Success success) {
        this.success = success;
    }

    public CompileTime getCompileTime() {
        return this.compileTime;
    }

    public void setCompileTime(CompileTime compileTime) {
        this.compileTime = compileTime;
    }

    public ExecutionTime getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(ExecutionTime executionTime) {
        this.executionTime = executionTime;
    }

    public Performance getPerformance() {
        return this.performance;
    }

    public void setPerformance(Performance performance) {
        this.performance = performance;
    }

    public boolean isSuccessfull() {
        return this.success.isPassed();
    }

    public boolean isHasTimedOut() {
        return this.success.isHasTimedOut();
    }

    public boolean isHasNotTimedOutButHasFailed() {
        return !this.success.isHasTimedOut() && !this.success.isPassed();
    }

    public boolean isPerformance() {
        return this.isPerformance;
    }

    public void setIsPerformance(boolean isPerformance) {
        this.isPerformance = isPerformance;
    }

    public boolean isCompileTime() {
        return this.isCompileTime;
    }

    public void setIsCompileTime(boolean isCompileTime) {
        this.isCompileTime = isCompileTime;
    }

    public boolean isExecutionTime() {
        return this.isExecutionTime;
    }

    public void setIsExecutionTime(boolean isExecutionTime) {
        this.isExecutionTime = isExecutionTime;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public void setIsSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public Platform getPlateforme() {
        return this.plateforme;
    }

    public void setPlateforme(Platform plateforme) {
        this.plateforme = plateforme;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Double> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Double> metrics) {
        this.metrics = metrics;
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("Test " + this.getName());
        strb.append("\n Description of the platform :" + this.plateforme.getName());
        strb.append("\n Os Name :" + this.plateforme.getOsName());
        strb.append("\n---------------------------------------");
        if (this.isCompileTime) {
            strb.append("\nCompile Time : " + this.compileTime.getMeasure() + " " + this.compileTime.getUnit());
        }
        if (this.isExecutionTime) {
            strb.append("\nExecution Time : " + this.executionTime.getMeasure() + " " + this.executionTime.getUnit());
        }
        if (this.isPerformance) {
            strb.append("\nPerformance : " + this.performance.getMeasure() + " " + this.performance.getUnit());
        }
        if (this.isSuccess) {
            strb.append("\nSuccess State : " + this.success.getState() + " %");
        }
        if (this.metrics.size() > 0) {
            strb.append("\nYour metrics : ");
            for (String metric_name : this.metrics.keySet()) {
                strb.append("\n" + metric_name + " : " + this.metrics.get(metric_name));
            }
        }
        return strb.toString();
    }

    @Override
    public int compareTo(Test test) {
        return this.name.compareTo(test.getName());
    }
}

