/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.plugins.PerfPublisher.PerfPublisherBuildAction;
import hudson.plugins.PerfPublisher.Report.Test;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDetails
implements ModelObject {
    private final Test test;
    private final AbstractBuild<?, ?> _owner;

    public TestDetails(AbstractBuild<?, ?> owner, Test test) {
        this.test = test;
        this._owner = owner;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this._owner;
    }

    public String getDisplayName() {
        return "Details of test " + this.test.getName();
    }

    public Test getTest() {
        return this.test;
    }

    public String getSuccessGraph() {
        List ob_builds;
        String result = "";
        List builds = ob_builds = this._owner.getProject().getBuilds();
        float taille_case = 100.0f / (float)Math.min(builds.size(), 25);
        int total = 0;
        int indice_build = 0;
        for (int j = 0; j < Math.min(builds.size(), 25); ++j) {
            PerfPublisherBuildAction action;
            Object build = builds.get(j);
            String numberBuild = "#";
            String color = "white";
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (!abstractBuild.isBuilding() && abstractBuild.getResult().isBetterOrEqualTo(Result.SUCCESS) && (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) != null && action.getReport() != null) {
                Test prev_test = action.getReports().getTestWithName(this.test.getName());
                color = prev_test != null ? (!prev_test.isExecuted() ? "orange" : (prev_test.isSuccessfull() && prev_test.isExecuted() ? "blue" : "red")) : "grey";
            }
            numberBuild = "#" + abstractBuild.getNumber();
            total = (int)((float)total + taille_case);
            if (indice_build == Math.min(builds.size(), 25) - 1 && total < 100) {
                taille_case += (float)(100 - total);
            }
            result = result + "<div id=\"" + color + "\" style=\"width:" + taille_case + "%;\">" + numberBuild + "</div>";
        }
        return result;
    }

    public void doPerformanceGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createPerformanceGraph(), (int)800, (int)250);
    }

    private JFreeChart createPerformanceGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractBuild build : this._owner.getProject().getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.SUCCESS) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReport() == null) continue;
            for (int i = 0; i < action.getReports().getNumberOfTest(); ++i) {
                if (!action.getReports().getTests().get(i).getName().equals(this.test.getName()) || !action.getReports().getTests().get(i).isPerformance()) continue;
                builder.add((Number)action.getReports().getTests().get(i).getPerformance().getMeasure(), (Comparable)((Object)"Performance"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart3D((String)"Evolution of Performance", (String)"Build", (String)"Performance", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.4f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public void doExecutionTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createExecutionTimeGraph(), (int)800, (int)250);
    }

    private JFreeChart createExecutionTimeGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractBuild build : this._owner.getProject().getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.SUCCESS) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReport() == null) continue;
            for (int i = 0; i < action.getReports().getNumberOfTest(); ++i) {
                if (!action.getReports().getTests().get(i).getName().equals(this.test.getName()) || !action.getReports().getTests().get(i).isExecutionTime()) continue;
                builder.add((Number)action.getReports().getTests().get(i).getExecutionTime().getMeasure(), (Comparable)((Object)"Execution Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart3D((String)"Evolution of Execution Time", (String)"Build", (String)"Execution time", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.4f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public void doCompileTimeGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createCompileTimeGraph(), (int)800, (int)250);
    }

    private JFreeChart createCompileTimeGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (AbstractBuild build : this._owner.getProject().getBuilds()) {
            PerfPublisherBuildAction action;
            AbstractBuild abstractBuild = build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.SUCCESS) || (action = (PerfPublisherBuildAction)abstractBuild.getAction(PerfPublisherBuildAction.class)) == null || action.getReport() == null) continue;
            for (int i = 0; i < action.getReports().getNumberOfTest(); ++i) {
                if (!action.getReports().getTests().get(i).getName().equals(this.test.getName()) || !action.getReports().getTests().get(i).isCompileTime()) continue;
                builder.add((Number)action.getReports().getTests().get(i).getCompileTime().getMeasure(), (Comparable)((Object)"Compile Time"), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            }
        }
        JFreeChart chart = ChartFactory.createLineChart3D((String)"Evolution of Compile Time", (String)"Build", (String)"Compile time", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.4f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)ColorPalette.BLUE);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }
}

