/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher.projectsAction;

import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.PerfPublisher.AbstractPerfPublisherAction;
import hudson.plugins.PerfPublisher.MatrixTestReportAction;
import hudson.plugins.PerfPublisher.PerfPublisherBuildAction;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.matrixBuild.PerfPublisherMatrixBuild;
import hudson.plugins.PerfPublisher.matrixBuild.PerfPublisherMatrixSubBuild;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfPublisherMatrixProjectAction
extends AbstractPerfPublisherAction {
    private final MatrixProject project;
    private final int max_nb_build = 10;

    public PerfPublisherMatrixProjectAction(MatrixProject project) {
        this.project = project;
    }

    @Override
    public String getDisplayName() {
        return "Global test report";
    }

    public MatrixProject getProject() {
        return this.project;
    }

    public ReportContainer getReports() {
        PerfPublisherBuildAction ac;
        Run ob = this.getProject().getLastSuccessfulBuild();
        AbstractBuild build = (AbstractBuild)ob;
        if (build != null && (ac = (PerfPublisherBuildAction)build.getAction(PerfPublisherBuildAction.class)) != null) {
            return ac.getReports();
        }
        return null;
    }

    public PerfPublisherBuildAction getActionByBuildNumber(int number) {
        return (PerfPublisherBuildAction)((MatrixBuild)this.project.getBuildByNumber(number)).getAction(PerfPublisherBuildAction.class);
    }

    public String getHtmlArrayDisplay() {
        StringBuilder strb = new StringBuilder();
        List<Integer> buildsNumber = this.computeBuildsToDisplay();
        strb.append("<table class=\"global_matrix_table\">\n");
        strb.append(this.generateHtmlArrayHeader(buildsNumber));
        strb.append(this.generateHtmlArrayContent(buildsNumber));
        strb.append("</table>");
        return strb.toString();
    }

    private List<Integer> computeBuildsToDisplay() {
        ArrayList<Integer> builds = new ArrayList<Integer>();
        for (MatrixBuild build : this.project.getBuilds()) {
            if (build.isBuilding() || !build.getResult().isBetterOrEqualTo(Result.SUCCESS) || build.getAction(MatrixTestReportAction.class) == null) continue;
            builds.add(build.getNumber());
        }
        Collections.sort(builds);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int start = 0;
        if (builds.size() > 10) {
            start = builds.size() - 10;
        }
        for (int i = builds.size() - 1; i >= start; --i) {
            result.add((Integer)builds.get(i));
        }
        Collections.sort(result);
        return result;
    }

    private String generateHtmlArrayHeader(List<Integer> builds) {
        StringBuilder strb = new StringBuilder();
        strb.append("<tr class=\"header\">");
        strb.append("<td style=\"width:170px;\">Statistics</td><td>Combination</td>");
        for (int i_build = builds.size() - 1; i_build >= 0; --i_build) {
            MatrixBuild matrixBuild = (MatrixBuild)this.project.getBuildByNumber(builds.get(i_build).intValue());
            strb.append("<td");
            if (matrixBuild.getResult() == Result.SUCCESS) {
                strb.append(" class=\"blue\"");
            } else if (matrixBuild.getResult() == Result.ABORTED || matrixBuild.getResult() == Result.FAILURE) {
                strb.append(" class=\"red\"");
            } else if (matrixBuild.getResult() == Result.UNSTABLE) {
                strb.append(" class=\"yellow\"");
            } else if (matrixBuild.getResult() == Result.NOT_BUILT) {
                strb.append(" class=\"grey\"");
            }
            strb.append("><small>build</small> " + matrixBuild.getNumber() + "</td>");
        }
        strb.append("</tr>");
        return strb.toString();
    }

    private String generateHtmlArrayContent(List<Integer> builds) {
        StringBuilder strb = new StringBuilder();
        Map<String, Map<String, Map<Integer, Float>>> values = this.getStaticticsValues(builds);
        Set<String> statsNames = values.keySet();
        for (String statsName : statsNames) {
            Map<String, Map<Integer, Float>> values2 = values.get(statsName);
            statsName = statsName.substring(statsName.indexOf(45) + 2);
            strb.append("<tr");
            strb.append(" onMouseOver=\"this.style.backgroundColor='#FFCC66';\"");
            strb.append(" onMouseOut=\"this.style.backgroundColor='#FFFFFF';\"");
            strb.append(">\n");
            strb.append("<td rowspan=\"" + values2.size() + "\"  class=\"statsRow\">\n");
            strb.append("<b>" + statsName + "</b>");
            strb.append("</td>\n");
            Set<String> combinations = values2.keySet();
            Iterator<String> iteratorOnCombinations = combinations.iterator();
            while (iteratorOnCombinations.hasNext()) {
                Float buildValue;
                int i_buildNumber;
                ArrayList<Integer> i_min_local = new ArrayList<Integer>();
                ArrayList<Integer> i_max_local = new ArrayList<Integer>();
                float min_local = 0.0f;
                float max_local = 0.0f;
                String combination = iteratorOnCombinations.next();
                Map<Integer, Float> buildValues = values2.get(combination);
                String tdClass = "";
                tdClass = !iteratorOnCombinations.hasNext() ? "class=\"combinationRow\" style=\"border-bottom:1px solid #000000;\"" : "class=\"combinationRow\"";
                strb.append("<td " + tdClass + ">" + combination + "</td>\n");
                for (i_buildNumber = builds.size() - 1; i_buildNumber >= 0; --i_buildNumber) {
                    if (!buildValues.containsKey(builds.get(i_buildNumber))) continue;
                    buildValue = buildValues.get(builds.get(i_buildNumber));
                    if (i_buildNumber == builds.size() - 1) {
                        i_max_local.add(builds.get(i_buildNumber));
                        i_min_local.add(builds.get(i_buildNumber));
                        max_local = min_local = buildValue.floatValue();
                        continue;
                    }
                    if (buildValue.floatValue() < min_local) {
                        min_local = buildValue.floatValue();
                        i_min_local = new ArrayList();
                        i_min_local.add(builds.get(i_buildNumber));
                        continue;
                    }
                    if (buildValue.floatValue() > max_local) {
                        max_local = buildValue.floatValue();
                        i_max_local = new ArrayList();
                        i_max_local.add(builds.get(i_buildNumber));
                        continue;
                    }
                    if (buildValue.floatValue() == min_local) {
                        i_min_local.add(builds.get(i_buildNumber));
                        continue;
                    }
                    if (buildValue.floatValue() != max_local) continue;
                    i_max_local.add(builds.get(i_buildNumber));
                }
                for (i_buildNumber = builds.size() - 1; i_buildNumber >= 0; --i_buildNumber) {
                    if (buildValues.containsKey(builds.get(i_buildNumber))) {
                        buildValue = buildValues.get(builds.get(i_buildNumber));
                        if (i_min_local.contains(builds.get(i_buildNumber))) {
                            strb.append("<td " + tdClass + "><font color=\"red\">" + buildValue + "</font></td>\n");
                            continue;
                        }
                        if (i_max_local.contains(builds.get(i_buildNumber))) {
                            strb.append("<td " + tdClass + "><font color=\"blue\">" + buildValue + "</font></td>\n");
                            continue;
                        }
                        strb.append("<td " + tdClass + ">" + buildValue + "</td>\n");
                        continue;
                    }
                    strb.append("<td " + tdClass + ">-</td>\n");
                }
                strb.append("</tr>\n");
                if (!iteratorOnCombinations.hasNext()) continue;
                strb.append("<tr");
                strb.append(" onMouseOver=\"this.style.backgroundColor='#FFCC66';\"");
                strb.append(" onMouseOut=\"this.style.backgroundColor='#FFFFFF';\"");
                strb.append(">\n");
            }
        }
        return strb.toString();
    }

    private Map<String, Map<String, Map<Integer, Float>>> getStaticticsValues(List<Integer> builds) {
        Map<String, Map<String, Map<Integer, Float>>> values = new TreeMap<String, Map<String, Map<Integer, Float>>>();
        for (int i_build = 0; i_build < builds.size(); ++i_build) {
            MatrixBuild build = (MatrixBuild)this.project.getBuildByNumber(builds.get(i_build).intValue());
            MatrixTestReportAction reportAction = (MatrixTestReportAction)build.getAction(MatrixTestReportAction.class);
            PerfPublisherMatrixBuild matrixBuild = reportAction.getMatrixBuild();
            if (matrixBuild == null) continue;
            List<PerfPublisherMatrixSubBuild> subBuilds = matrixBuild.getSubBuilds();
            for (int i_subBuild = 0; i_subBuild < subBuilds.size(); ++i_subBuild) {
                PerfPublisherMatrixSubBuild subBuild = subBuilds.get(i_subBuild);
                values = this.updateStatistics(values, "0 - Number of test", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getNumberOfTest() + 0.0f);
                values = this.updateStatistics(values, "1 - Number of executed test", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getNumberOfExecutedTest() + 0.0f);
                values = this.updateStatistics(values, "2 - Number of not executed test", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getNumberOfNotExecutedTest() + 0.0f);
                values = this.updateStatistics(values, "3 - Number of passed test", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getNumberOfPassedTest() + 0.0f);
                values = this.updateStatistics(values, "4 - Number of failed test", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getNumberOfFailedTest() + 0.0f);
                values = this.updateStatistics(values, "5 - Average of compile time", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getAverageOfCompileTime());
                values = this.updateStatistics(values, "6 - Average of execution time", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getAverageOfExecutionTime());
                values = this.updateStatistics(values, "7 - Average of performance", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getAverageOfPerformance());
                values = this.updateStatistics(values, "8 - Number of files", subBuild.getStringCombinations(), build.getNumber(), (float)subBuild.getReport().getNumberOfFiles() + 0.0f);
            }
        }
        return values;
    }

    private Map<String, Map<String, Map<Integer, Float>>> updateStatistics(Map<String, Map<String, Map<Integer, Float>>> values, String statsName, String stringCombinations, int buildNumber, float statsValue) {
        if (values.containsKey(statsName)) {
            Map<String, Map<Integer, Float>> tmp2 = values.get(statsName);
            if (tmp2.containsKey(stringCombinations)) {
                Map<Integer, Float> tmp_float = tmp2.get(stringCombinations);
                tmp_float.put(buildNumber, Float.valueOf(statsValue));
                tmp2.put(stringCombinations, tmp_float);
                values.put(statsName, tmp2);
            } else {
                HashMap<Integer, Float> tmp_float = new HashMap<Integer, Float>();
                tmp_float.put(buildNumber, Float.valueOf(statsValue));
                tmp2.put(stringCombinations, tmp_float);
                values.put(statsName, tmp2);
            }
        } else {
            HashMap<Integer, Float> tmp_float = new HashMap<Integer, Float>();
            tmp_float.put(buildNumber, Float.valueOf(statsValue));
            HashMap<String, HashMap<Integer, Float>> tmp2 = new HashMap<String, HashMap<Integer, Float>>();
            tmp2.put(stringCombinations, tmp_float);
            values.put(statsName, tmp2);
        }
        return values;
    }

    public void doSuccessGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createSuccessGraph(), (int)800, (int)250);
    }

    public void doMiniSuccessGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)this.createSuccessGraph(), (int)350, (int)1000);
    }

    private JFreeChart createSuccessGraph() {
        DataSetBuilder builder = new DataSetBuilder();
        for (MatrixBuild build : this.project.getBuilds()) {
            MatrixTestReportAction action;
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (abstractBuild.isBuilding() || !abstractBuild.getResult().isBetterOrEqualTo(Result.UNSTABLE) || (action = (MatrixTestReportAction)abstractBuild.getAction(MatrixTestReportAction.class)) == null || action.getMatrixBuild() == null || action.getMatrixBuild().getSubBuilds() == null) continue;
            List<PerfPublisherMatrixSubBuild> subBuilds = action.getMatrixBuild().getSubBuilds();
            Collections.sort(subBuilds);
            for (int i = 0; i < subBuilds.size(); ++i) {
                builder.add((Number)subBuilds.get(i).getReport().getNumberOfExecutedTest(), (Comparable)((Object)subBuilds.get(i).getStringCombinations()), (Comparable)new ChartUtil.NumberOnlyBuildLabel(abstractBuild));
            }
        }
        JFreeChart chart = ChartFactory.createStackedAreaChart((String)"Evolution of tests success", (String)"Build", (String)"Number of test", (CategoryDataset)builder.build(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
        renderer.setSeriesPaint(1, (Paint)ColorPalette.RED);
        renderer.setSeriesPaint(0, (Paint)ColorPalette.YELLOW);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
        return chart;
    }

    private boolean shouldReloadGraph(StaplerRequest request, StaplerResponse response) throws IOException {
        return this.shouldReloadGraph(request, response, this.project.getLastSuccessfulBuild());
    }
}

