/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.PerfPublisher.Report.Test;
import hudson.plugins.PerfPublisher.TrendReport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangedStatusTestsDetails
implements ModelObject {
    private final TrendReport report;
    private final AbstractBuild<?, ?> _owner;

    public ChangedStatusTestsDetails(AbstractBuild<?, ?> owner, TrendReport rep) {
        this.report = rep;
        this._owner = owner;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this._owner;
    }

    public String getDisplayName() {
        return "Details of status changed tests.";
    }

    public TrendReport getReport() {
        return this.report;
    }

    public String getPageContent() {
        Test t;
        int i;
        StringBuilder stb = new StringBuilder();
        List tests = this.report.getExecutionStatusChangedTests();
        if (tests.size() > 0) {
            stb.append("<table border=\"1px\" class=\"pane sortable\">");
            stb.append("<tr>");
            stb.append("<td class= \"pane-header\" title=\"Message\">Tests</td>");
            stb.append("<td class=\"pane-header\" title=\"Number of tests\">Execution status modification</td>");
            stb.append("</tr>");
            for (i = 0; i < tests.size(); ++i) {
                t = (Test)tests.get(i);
                stb.append("<tr><td><a class=\"info_bulle\" href=\"../testDetails." + t.getNameForUrl() + "\">" + t.getName() + "</a></td>");
                if (t.isExecuted()) {
                    stb.append("<td>Not executed <img border=\"0\" src=\"/plugin/PerfPublisher/icons/bullet_go.png\" /> <b>Executed</b></td>");
                } else {
                    stb.append("<td>Executed <img border=\"0\" src=\"/plugin/PerfPublisher/icons/bullet_go.png\" /> <b>Not executed</b></td>");
                }
                stb.append("</tr>");
            }
            stb.append("</table>");
        } else {
            stb.append("<b>None of the tests has changed of execution status.</b><br />");
        }
        tests = this.report.getSuccessStatusChangedTests();
        if (tests.size() > 0) {
            stb.append("<table border=\"1px\" class=\"pane sortable\">");
            stb.append("<tr>");
            stb.append("<td class= \"pane-header\" title=\"Message\">Tests</td>");
            stb.append("<td class=\"pane-header\" title=\"Number of tests\">Success status modification</td>");
            stb.append("</tr>");
            for (i = 0; i < tests.size(); ++i) {
                t = (Test)tests.get(i);
                stb.append("<tr><td><a class=\"info_bulle\" href=\"../testDetails." + t.getNameForUrl() + "\">" + t.getName() + "</a></td>");
                if (t.isSuccessfull()) {
                    stb.append("<td>Failed <img border=\"0\" src=\"/plugin/PerfPublisher/icons/bullet_go.png\" /> <b>Successfull</b></td>");
                } else {
                    stb.append("<td>Successfull <img border=\"0\" src=\"/plugin/PerfPublisher/icons/bullet_go.png\" /> <b>Failed</b></td>");
                }
                stb.append("</tr>");
            }
            stb.append("</table>");
        } else {
            stb.append("<b>None of the tests has changed of success status.</b><br />");
        }
        return stb.toString();
    }
}

