/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.plugins.PerfPublisher.ParserXml;
import hudson.plugins.PerfPublisher.PerfPublisherParseException;
import hudson.plugins.PerfPublisher.Report.Report;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ReportReader {
    private Report report;
    private final transient PrintStream hudsonConsoleWriter;

    public ReportReader(URI is, PrintStream logger) {
        this.hudsonConsoleWriter = logger;
        this.parse(is);
    }

    private void parse(URI is) {
        if (is == null) {
            throw new PerfPublisherParseException("Empty input stream");
        }
        if (this.report == null) {
            this.report = new Report();
        }
        try {
            ParserXml parseur = new ParserXml(is);
            parseur.parse();
            this.report = parseur.result();
        }
        catch (IOException e) {
            String errMsg = "[CapsAnalysis] Problem parsing Performance report file";
            this.hudsonConsoleWriter.println(errMsg + ": " + e.getMessage());
            e.printStackTrace(this.hudsonConsoleWriter);
            throw new PerfPublisherParseException(errMsg, (Exception)e);
        }
        catch (ParserConfigurationException e) {
            String errMsg = "[CapsAnalysis] Problem parsing Performance report file";
            this.hudsonConsoleWriter.println(errMsg + ": " + e.getMessage());
            e.printStackTrace(this.hudsonConsoleWriter);
            throw new PerfPublisherParseException(errMsg, (Exception)e);
        }
        catch (SAXException e) {
            String errMsg = "[CapsAnalysis] Problem parsing Performance report file";
            this.hudsonConsoleWriter.println(errMsg + ": " + e.getMessage());
            e.printStackTrace(this.hudsonConsoleWriter);
            throw new PerfPublisherParseException(errMsg, (Exception)e);
        }
    }

    public Report getReport() {
        return this.report;
    }
}

