/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.PerfPublisher;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.PerfPublisher.Report.ReportContainer;
import hudson.plugins.PerfPublisher.Report.Test;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportsDiff
implements ModelObject {
    private final AbstractBuild<?, ?> _owner;
    private ReportContainer report1;
    private ReportContainer report2;
    private ReportContainer report3;
    private int nb_build1;
    private int nb_build2;
    private int nb_build3;
    private boolean shortDiff;
    private String link;

    public ReportsDiff(AbstractBuild<?, ?> owner, StaplerRequest request, int nb_build1, ReportContainer report1, int nb_build2, ReportContainer report2, int nb_build3, ReportContainer report3) {
        this._owner = owner;
        this.report1 = report1;
        this.report2 = report2;
        this.report3 = report3;
        this.nb_build1 = nb_build1;
        this.nb_build2 = nb_build2;
        this.nb_build3 = nb_build3;
        this.link = "?build1=" + this.nb_build1 + "&build2=" + this.nb_build2;
        this.link = this.nb_build3 == 0 ? this.link + "&build3=none" : this.link + "&build3=" + this.nb_build3;
        this.shortDiff = false;
        if (request.getParameter("short") != null && request.getParameter("short").equals("yes")) {
            this.shortDiff = true;
            this.link = this.link + "&short=no";
        } else {
            this.link = this.link + "&short=yes";
        }
    }

    public String getBuild1Number() {
        return "" + this.nb_build1;
    }

    public String getBuild2Number() {
        return "" + this.nb_build2;
    }

    public String getBuild3Number() {
        return "" + this.nb_build3;
    }

    public ReportContainer getReport1() {
        return this.report1;
    }

    public List<Test> getReport1Tests() {
        return this.report1.getTests();
    }

    public ReportContainer getReport2() {
        return this.report2;
    }

    public List<Test> getReport2Tests() {
        return this.report2.getTests();
    }

    public ReportContainer getReport3() {
        return this.report3;
    }

    public List<Test> getReport3Tests() {
        return this.report3.getTests();
    }

    public String getHtmlTestsDiff() {
        int j;
        boolean insert;
        int i;
        String style = "Threecolumn";
        if (this.nb_build3 == 0) {
            style = "Twocolumn";
        }
        StringBuilder strb = new StringBuilder();
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Build number</div>");
        strb.append("<div class=\"" + style + "\"><b>Build " + this.nb_build1 + "</b></div>");
        strb.append("<div class=\"" + style + "\"><b>Build " + this.nb_build2 + "</b></div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\"><b>Build " + this.nb_build3 + "</b></div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Build date</div>");
        strb.append("<div class=\"" + style + "\">" + ((AbstractBuild)this._owner.getProject().getBuildByNumber(this.nb_build1)).getTimestampString2() + "</div>");
        strb.append("<div class=\"" + style + "\">" + ((AbstractBuild)this._owner.getProject().getBuildByNumber(this.nb_build2)).getTimestampString2() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + ((AbstractBuild)this._owner.getProject().getBuildByNumber(this.nb_build3)).getTimestampString2() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Number of executed tests</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getNumberOfExecutedTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getNumberOfExecutedTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getNumberOfExecutedTest() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Number of not executed tests</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getNumberOfNotExecutedTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getNumberOfNotExecutedTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getNumberOfNotExecutedTest() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Number of succeeded tests</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getNumberOfPassedTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getNumberOfPassedTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getNumberOfPassedTest() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Number of failed tests</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getNumberOfFailedTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getNumberOfFailedTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getNumberOfFailedTest() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Compile time (Average/Number of measures)</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getAverageOfCompileTime() + "/" + this.report1.getNumberOfCompileTimeTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getAverageOfCompileTime() + "/" + this.report2.getNumberOfCompileTimeTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getAverageOfCompileTime() + "/" + this.report3.getNumberOfCompileTimeTest() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Execution time (Average/Number of measures)</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getAverageOfExecutionTime() + "/" + this.report1.getNumberOfExecutionTimeTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getAverageOfExecutionTime() + "/" + this.report2.getNumberOfExecutionTimeTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getAverageOfExecutionTime() + "/" + this.report3.getNumberOfExecutionTimeTest() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Performance (Average/Number of measures)</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getAverageOfPerformance() + "/" + this.report1.getNumberOfPerformanceTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getAverageOfPerformance() + "/" + this.report2.getNumberOfPerformanceTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getAverageOfPerformance() + "/" + this.report3.getNumberOfPerformanceTest() + "</div>");
        }
        strb.append("</div>");
        strb.append("<div class=\"line\">");
        strb.append("<div class=\"header\">Performance (Average/Number of measures)</div>");
        strb.append("<div class=\"" + style + "\">" + this.report1.getAverageOfPerformance() + "/" + this.report1.getNumberOfPerformanceTest() + "</div>");
        strb.append("<div class=\"" + style + "\">" + this.report2.getAverageOfPerformance() + "/" + this.report2.getNumberOfPerformanceTest() + "</div>");
        if (this.nb_build3 != 0) {
            strb.append("<div class=\"" + style + "\">" + this.report3.getAverageOfPerformance() + "/" + this.report3.getNumberOfPerformanceTest() + "</div>");
        }
        strb.append("<br style=\"clear:both;\"></div>&nbsp;");
        strb.append("<div class=\"legende\">");
        strb.append("<div id=\"grey\">NOT EXECUTED</div>");
        strb.append("<div id=\"yellow\">TIMED OUT</div>");
        strb.append("<div id=\"red\">FAILED</div>");
        strb.append("<div id=\"green\">SUCCESSFULL</div>");
        strb.append("<div id=\"white\">DOESN'T EXIST</div>");
        strb.append("<div id=\"link_display\">");
        if (this.shortDiff) {
            strb.append("<a href=\"" + this.link + "\">Display the full diff</a>");
        } else {
            strb.append("<a href=\"" + this.link + "\">Display the short diff</a>");
        }
        strb.append("</div>");
        strb.append("</div>");
        ArrayList global_test = new ArrayList();
        global_test.addAll(this.report1.getTests());
        for (i = 0; i < this.report2.getTests().size(); ++i) {
            insert = true;
            for (j = 0; j < global_test.size(); ++j) {
                if (!((Test)global_test.get(j)).getName().equals(((Test)this.report2.getTests().get(i)).getName())) continue;
                insert = false;
            }
            if (!insert) continue;
            global_test.add(this.report2.getTests().get(i));
        }
        if (this.report3 != null) {
            for (i = 0; i < this.report3.getTests().size(); ++i) {
                insert = true;
                for (j = 0; j < global_test.size(); ++j) {
                    if (!((Test)global_test.get(j)).getName().equals(((Test)this.report3.getTests().get(i)).getName())) continue;
                    insert = false;
                }
                if (!insert) continue;
                global_test.add(this.report3.getTests().get(i));
            }
        }
        Collections.sort(global_test);
        for (i = 0; i < global_test.size(); ++i) {
            String color1 = "#fff";
            String color2 = "#fff";
            String color3 = "#fff";
            String txt1 = "-";
            String txt2 = "-";
            String txt3 = "-";
            if (this.report1.getTestWithName(((Test)global_test.get(i)).getName()) != null) {
                Test test1 = this.report1.getTestWithName(((Test)global_test.get(i)).getName());
                txt1 = "<a href=\"../../../" + this.nb_build1 + "/PerfPublisher/testDetails." + test1.getNameForUrl() + "\">x</a>";
                color1 = !test1.isExecuted() ? "grey" : (test1.isHasTimedOut() ? "yellow" : (test1.isSuccessfull() ? "green" : "red"));
            }
            if (this.report2.getTestWithName(((Test)global_test.get(i)).getName()) != null) {
                Test test2 = this.report2.getTestWithName(((Test)global_test.get(i)).getName());
                txt2 = "<a href=\"../../../" + this.nb_build2 + "/PerfPublisher/testDetails." + test2.getNameForUrl() + "\">x</a>";
                color2 = !test2.isExecuted() ? "grey" : (test2.isHasTimedOut() ? "yellow" : (test2.isSuccessfull() ? "green" : "red"));
            }
            if (this.nb_build3 != 0) {
                if (this.report3.getTestWithName(((Test)global_test.get(i)).getName()) != null) {
                    Test test3 = this.report3.getTestWithName(((Test)global_test.get(i)).getName());
                    txt3 = "<a href=\"../../../" + this.nb_build3 + "/PerfPublisher/testDetails." + test3.getNameForUrl() + "\">x</a>";
                    color3 = !test3.isExecuted() ? "grey" : (test3.isHasTimedOut() ? "yellow" : (test3.isSuccessfull() ? "green" : "red"));
                }
                if (this.shortDiff && (color1 != color2 || color1 != color3 || color2 != color3)) {
                    strb.append("<div class=\"line\">");
                    strb.append("<div class=\"header\">" + ((Test)global_test.get(i)).getName() + "</div>");
                    strb.append("<div class=\"" + style + "\" style=\"background-color:" + color1 + "\"> " + txt1 + " </div>");
                    strb.append("<div class=\"" + style + "\" style=\"background-color:" + color2 + "\"> " + txt2 + " </div>");
                    strb.append("<div class=\"" + style + "\" style=\"background-color:" + color3 + "\"> " + txt3 + " </div>");
                    strb.append("</div>\n");
                    continue;
                }
                if (this.shortDiff) continue;
                strb.append("<div class=\"line\">");
                strb.append("<div class=\"header\">" + ((Test)global_test.get(i)).getName() + "</div>");
                strb.append("<div class=\"" + style + "\" style=\"background-color:" + color1 + "\"> " + txt1 + " </div>");
                strb.append("<div class=\"" + style + "\" style=\"background-color:" + color2 + "\"> " + txt2 + " </div>");
                strb.append("<div class=\"" + style + "\" style=\"background-color:" + color3 + "\"> " + txt3 + " </div>");
                strb.append("</div>\n");
                continue;
            }
            if (this.shortDiff && color1 != color2) {
                strb.append("<div class=\"line\">");
                strb.append("<div class=\"header\">" + ((Test)global_test.get(i)).getName() + "</div>");
                strb.append("<div class=\"" + style + "\" style=\"background-color:" + color1 + "\"> " + txt1 + " </div>");
                strb.append("<div class=\"" + style + "\" style=\"background-color:" + color2 + "\"> " + txt2 + " </div>");
                strb.append("</div>\n");
                continue;
            }
            if (this.shortDiff) continue;
            strb.append("<div class=\"line\">");
            strb.append("<div class=\"header\">" + ((Test)global_test.get(i)).getName() + "</div>");
            strb.append("<div class=\"" + style + "\" style=\"background-color:" + color1 + "\"> " + txt1 + " </div>");
            strb.append("<div class=\"" + style + "\" style=\"background-color:" + color2 + "\"> " + txt2 + " </div>");
            strb.append("</div>\n");
        }
        return strb.toString();
    }

    public AbstractBuild<?, ?> getOwner() {
        return this._owner;
    }

    public String getDisplayName() {
        return "Reports diff.";
    }
}

